package com.elitescloud.cloudt.lowcode.dynamic.model.bo;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Map;

/**
 * 功能模块的工作流配置信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/24
 */
@Getter
@Setter
public class DynamicWorkflowCfgSimpleBO implements Serializable {
    private static final long serialVersionUID = 914088790331048129L;

    /**
     * 是否已创建审批流程
     */
    private Boolean createdApproval;

    /**
     * 是否已部署流程
     */
    private Boolean deployedApproval;

    /**
     * 审批类型 UDC[cloudt-system:approveType]
     * <p>
     * {@link com.elitescloud.cloudt.lowcode.dynamic.common.ApproveTypeUdc}
     */
    private String approvalType;

    /**
     * 工作流引擎
     */
    private String approvalEngine;

    /**
     * 流程定义Key
     */
    private String approvalKey;

    /**
     * 流程JSON
     */
    private Map<String, Object> approvalJson;

}
