package com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp;

import com.elitescloud.cloudt.lowcode.dynamic.model.convert.BoModelFieldTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 表字段列表信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/23
 */
@Getter
@Setter
@ApiModel(description = "表字段列表信息")
public class DynamicConfiguratorBoFieldListRespVO implements Serializable {
    private static final long serialVersionUID = -4768979589955737062L;

    @ApiModelProperty(value = "字段ID", position = 1)
    private Long boFieldId;

    @ApiModelProperty(value = "是否是数据库字段", position = 2, example = "true")
    private Boolean dbField;

    @ApiModelProperty(value = "字段标识Key", position = 3)
    private String basicKey;

    @ApiModelProperty(value = "字段名称", position = 5)
    private String basicName;

    @ApiModelProperty(value = "字段类型", position = 6)
    private BoModelFieldTypeEnum basicType;
    private BoModelFieldTypeEnum basicTypeName;

    @ApiModelProperty(value = "字段描述", position = 7)
    private String basicDescription;

    @ApiModelProperty(value = "字段长度", position = 11)
    private Integer dbFieldLength;

    @ApiModelProperty(value = "小数位数", position = 12)
    private Integer dbFieldPrecision;

    @ApiModelProperty(value = "小数部分位数", position = 13)
    private Integer dbFieldScale;

    @ApiModelProperty(value = "是否可为空", position = 14)
    private Boolean dbFieldNullable;

    @ApiModelProperty(value = "是否唯一", position = 16)
    private Boolean dbFieldUnique;

    @ApiModelProperty(value = "是否索引", position = 17)
    private Boolean dbFieldIndex;

    @ApiModelProperty(value = "显示顺序", position = 21)
    private Integer basicDisplayOrder;

    @ApiModelProperty(value = "组件展示风格", position = 22)
    private String displayType;
}
