package com.elitescloud.cloudt.lowcode.dynamic.service.db;

import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbFieldRelationDo;

import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-02 10:20
 */
/**
 * DbFieldRelationService 接口定义了数据库字段关系服务的方法。
 * 用于操作数据库字段关系实体（DbFieldRelationDo）的相关方法。
 */
public interface DbFieldRelationService {

    /**
     * 查找所有数据库字段关系记录。
     *
     * @return 返回包含所有数据库字段关系记录的列表。
     */
    List<DbFieldRelationDo> findAll();

    /**
     * 根据ID查找数据库字段关系记录。
     *
     * @param id 字段关系的唯一标识符。
     * @return 返回匹配给定ID的数据库字段关系记录，如果找不到则返回null。
     */
    DbFieldRelationDo findById(Long id);

    /**
     * 保存或更新数据库字段关系记录。
     *
     * @param dbFieldRelation 要保存或更新的数据库字段关系对象。
     * @return 返回保存或更新后的数据库字段关系对象。
     */
    DbFieldRelationDo save(DbFieldRelationDo dbFieldRelation);

    /**
     * 根据ID删除数据库字段关系记录。
     *
     * @param id 要删除的字段关系的唯一标识符。
     */
    void delete(Long id);
}

