package com.elitescloud.cloudt.lowcode.dynamic.service.db;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbFieldDo;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DbFieldVo;

import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-02 10:20
 */
public interface DbFieldService {
    /**
     * 根据表名查找字段信息
     * @param tableName 表名
     * @return 匹配表名的字段信息列表
     */
    List<DbFieldVo> findByTableName(String tableName);

    /**
     * 查找所有字段信息
     * @return 所有字段信息列表
     */
    List<DbFieldDo> findAll();

    /**
     * 根据ID查找字段信息
     * @param id 字段的ID
     * @return 匹配给定ID的字段信息，如果找不到则返回null
     */
    DbFieldDo findById(Long id);

    /**
     * 保存或更新字段信息
     * @param dbField 要保存或更新的字段对象
     * @return 保存或更新后的字段对象
     */
    DbFieldDo save(DbFieldDo dbField);

    /**
     * 根据ID删除字段信息
     * @param id 要删除的字段的ID
     */
    void delete(Long id);

    // 收集并存储指定表的字段元数据
    /**
     * 存储指定表的元数据信息。
     * @param tableName 需要存储元数据的表名。
     * @return 返回操作结果，包含成功或失败的信息。
     */
//    ApiResult<String> storeFieldsMetadata(String schema, String tableName);
}
