package com.elitescloud.cloudt.lowcode.dynamic.service.db;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbFieldDo;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbTableDo;
import org.jooq.Schema;
import org.springframework.transaction.annotation.Transactional;

import java.sql.SQLException;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-16 14:12
 */
public interface DbMetadataService {


    /**
     * 获取指定表的字段信息。
     *
     * @param tableName 需要获取字段信息的表名。
     * @return 返回包含字段详细信息的列表。
     */
    List<DbFieldDo> getDbTableFieldDo(String schema, String tableName);

    /**
     * 获取指定表的信息。
     *
     * @param tableName 需要获取信息的表名。
     * @return 返回包含表详细信息的列表。
     */
    List<DbTableDo> getDbTableDo(String schema, String tableName);

    /**
     * 获取当前的数据库模式。
     *
     * @return 返回当前使用的数据库模式名称。
     */
    String getCurrentSchema();

    List<String> getAllSchemas();

}
