package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 09:49
 */

import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoModelDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicBoModelDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelAddViewJsonParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicBoModelVo;
import com.querydsl.core.types.Predicate;

import java.util.List;

public interface DynamicBoModelService {
    static Predicate getPredicateByBoModelQueryParam(BoModelQueryParam boModelParam) {
        var QDO = QDynamicBoModelDO.dynamicBoModelDO;
        var predicate = JpaPredicateBuilder.builder()
                .and(QDO.boModelCode::eq, boModelParam.getBoModelCode())
                .and(QDO.databaseTableName::eq, boModelParam.getDatabaseTableName())
                .getPredicate();
        return predicate;
    }

    ApiResult<Long> createBoModel(BoModelSaveParam boModelParam);

    DynamicBoModelDO getBoModelByCode(String boModelCode);

    DynamicBoModelDO getBoModelById(Long boModelId);

    ApiResult<Boolean> updateBoModel(String boModelCode, BoModelUpdateParam boModelDetails);

    ApiResult<Boolean> updateBoModelById(Long boModelId, BoModelUpdateParam boModelDetails);

    ApiResult<Boolean> deleteBoModel(String boModelCode);

    ApiResult<Boolean> deleteBoModelById(Long boModelId);

    PagingVO<DynamicBoModelDO> searchBoModels(BoModelQueryParam boModelParam);

    List<DynamicBoModelDO> searchBoModelList(BoModelQueryParam boModelParam);

    DynamicBoModelVo getBoModelVoByCode(String boModelCode);

      void updateCreateTable(String boModelCode,boolean b);

    ApiResult<String> updateBoModelFormJson(BoModelAddViewJsonParam param);

    ApiResult<String> updateBoModelListPageJson(BoModelAddViewJsonParam param);
}
