package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.query.DynamicConfiguratorPageQueryVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.*;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.save.*;
import com.elitescloud.cloudt.lowcode.dynamic.service.spi.common.WorkflowStatus;

import java.util.List;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/22
 */
public interface DynamicConfigurationMngService {

    /**
     * 保存功能模块信息
     *
     * @param saveVO 功能模块信息
     * @return
     */
    ApiResult<Long> saveDynamicConfigurator(DynamicConfiguratorSaveVO saveVO);

    /**
     * 发布功能模块
     *
     * @param saveVO 发布信息
     * @return
     */
    ApiResult<Long> publishDynamicConfigurator(DynamicConfiguratorPublishSaveVO saveVO);

    /**
     * 取消发布功能模块
     *
     * @param id 功能模块ID
     * @return
     */
    ApiResult<Long> revokePublishDynamicConfigurator(Long id);

    /**
     * 删除功能模块
     *
     * @param id 功能模块ID
     * @return
     */
    ApiResult<Long> deleteDynamicConfigurator(Long id);

    /**
     * 保存数据模型
     *
     * @param saveVO 数据模型信息
     * @return
     */
    ApiResult<Long> saveBoModel(DynamicBoModelSaveVO saveVO);

    /**
     * 删除数据模型
     *
     * @param id          功能模块ID
     * @param boModelId   数据模型ID
     * @param deleteModel 是否同时删除模型
     * @return
     */
    ApiResult<Long> deleteBoModel(Long id, Long boModelId, Boolean deleteModel);

    /**
     * 新增模型字段
     *
     * @param boModelId   数据模型ID
     * @param fieldSaveVO 字段保存信息
     * @return
     */
    ApiResult<Long> addBoModelField(Long boModelId, DynamicBoFieldSaveVO fieldSaveVO);

    /**
     * 删除模型字段
     *
     * @param boFieldId 字段ID
     * @return
     */
    ApiResult<Long> deleteBoModelField(Long boFieldId);

    /**
     * 保存字段模型列表
     *
     * @param boModelId     数据模型ID
     * @param fieldSaveList 字段保存信息
     * @return
     */
    ApiResult<Long> saveBoModelFields(Long boModelId, List<DynamicBoFieldSaveVO> fieldSaveList);

    /**
     * 保存表单配置
     *
     * @param formSaveVO 表单配置信息
     * @return
     */
    ApiResult<Long> saveFormCfg(DynamicConfiguratorFormSaveVO formSaveVO);

    /**
     * 保存列表配置
     *
     * @param listPageSaveVO 列表配置信息
     * @return
     */
    ApiResult<Long> saveListPageCfg(DynamicConfiguratorListPageSaveVO listPageSaveVO);

    /**
     * 保存审批设计信息
     *
     * @param saveVO 审批设计信息
     * @return
     */
    ApiResult<Long> saveApproval(DynamicConfiguratorApprovalSaveVO saveVO);

    /**
     * 部署流程
     *
     * @param id 功能模块ID
     * @return
     */
    ApiResult<Long> deployApproval(Long id);

    /**
     * 删除流程
     *
     * @param id 功能模块ID
     * @return
     */
    ApiResult<Long> deleteApproval(Long id);

    /**
     * 部署
     *
     * @param id 功能模块ID
     * @return
     */
    ApiResult<Long> deploy(Long id);

    /**
     * 重新部署
     * <p>
     * 删除后重新部署
     *
     * @param id 功能模块ID
     * @return
     */
    ApiResult<Long> redeploy(Long id);

    /**
     * 取消部署
     * <p>
     * 删除表
     *
     * @param id 功能模块ID
     * @return
     */
    ApiResult<Long> cancelDeploy(Long id);

    /**
     * 获取功能模块详细信息
     *
     * @param id 功能模块ID
     * @return
     */
    ApiResult<DynamicConfiguratorDetailRespVO> getDynamicConfigurator(Long id);

    /**
     * 分页查询管理
     *
     * @param queryVO 查询参数
     * @return
     */
    ApiResult<PagingVO<DynamicConfiguratorPageRespVO>> pageQuery(DynamicConfiguratorPageQueryVO queryVO);

    /**
     * 获取模型列表
     *
     * @param id 功能模块ID
     * @return
     */
    ApiResult<List<DynamicConfiguratorBoModelListRespVO>> listBoModel(Long id);

    /**
     * 获取模型详细信息列表
     *
     * @param id
     * @return
     */
    ApiResult<List<DynamicConfiguratorBoModelDetailListRespVO>> listBoModelDetail(Long id);

    /**
     * 获取模型信息
     *
     * @param id        功能模块ID
     * @param boModelId 数据模型ID
     * @return
     */
    ApiResult<DynamicConfiguratorBoModelDetailRespVO> getBoModel(Long id, Long boModelId);

    /**
     * 获取模型的字段列表
     *
     * @param boModelId 数据模型ID
     * @return
     */
    ApiResult<List<DynamicConfiguratorBoFieldListRespVO>> getBoFieldList(Long boModelId);

    /**
     * 获取字段详情
     *
     * @param boFieldId 字段ID
     * @return
     */
    ApiResult<DynamicConfiguratorBoFieldDetailRespVO> getBoFieldDetail(Long boFieldId);

    /**
     * 获取表单配置
     *
     * @param id 功能模块ID
     * @return
     */
    ApiResult<Map<String, Object>> getFormCfg(Long id);

    /**
     * 获取列表配置
     *
     * @param id 功能模块ID
     * @return
     */
    ApiResult<Map<String, Object>> getListPageCfg(Long id);

    /**
     * 获取审批设计信息
     *
     * @param id 功能模块ID
     * @return
     */
    ApiResult<DynamicConfiguratorApprovalRespVO> getApprovalInfo(Long id);

    /**
     * 获取工作流引擎列表
     *
     * @return
     */
    ApiResult<List<CodeNameParam>> getApprovalEngineList();

    /**
     * 获取工作流引擎状态
     *
     * @param engineType 流程引擎类型
     * @return
     */
    ApiResult<WorkflowStatus> getApprovalEngineStatus(String engineType);

    /**
     * 获取部署信息
     *
     * @param id 功能模块ID
     * @return
     */
    ApiResult<DynamicDeployInfoRespVO> getDeployInfo(Long id);
}
