package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldDefinitionUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicBoModelVo;
import com.elitescloud.cloudt.lowcode.dynamic.repo.BoModelRepository;
import com.elitescloud.cloudt.lowcode.dynamic.repo.ConfiguratorBoModelRelationRepository;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbAuditFieldService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 10:06
 */
@Service
@Slf4j
public class DynamicBoModelDbServiceImpl implements DynamicBoModelDbService {
    private final BoModelRepository repository;

    private final ConfiguratorBoModelRelationRepository configuratorBoModelRelationRepository;

    private final DynamicBoFieldDefinitionService boFieldDefinitionService;

    private final DatabaseTableOperations dbDatabaseService;

    private final DynamicBoModelService boModelService;
    private final DbAuditFieldService dbAuditFieldService;



    public DynamicBoModelDbServiceImpl(BoModelRepository repository,
                                       ConfiguratorBoModelRelationRepository configuratorBoModelRelationRepository,
                                       DynamicBoFieldDefinitionService boFieldDefinitionService,
                                       DatabaseTableOperations dbDatabaseService, DynamicBoModelService boModelService,
                                       DbAuditFieldService dbAuditFieldService) {
        this.repository = repository;
        this.configuratorBoModelRelationRepository = configuratorBoModelRelationRepository;
        this.boFieldDefinitionService = boFieldDefinitionService;
        this.dbDatabaseService = dbDatabaseService;
        this.boModelService = boModelService;
        this.dbAuditFieldService = dbAuditFieldService;

    }


    @Override
    @Transactional
    public ApiResult<String> createBoModelDbTable(String boModelCode) {
        DynamicBoModelVo dynamicBoModelVo = boModelService.getBoModelVoByCode(boModelCode);
        if (dynamicBoModelVo != null) {
            if (dynamicBoModelVo.getCreationTable()!=null&&dynamicBoModelVo.getCreationTable() == true) {
                return ApiResult.fail("模型表已经创建状态");
            }
//            List<DbTableDo> dbTableDo=dbMetadataService.getDbTableDo(dynamicBoModelVo.getDatabaseTableName());
//            if (dbTableDo==null||dbTableDo.size()==0){
//                return ApiResult.fail("模型表不存在"+dynamicBoModelVo.getDatabaseTableName());
//            }
            List<DynamicBoFieldDefinitionDO> dynamicBoFieldDefinitionDOList =
                    dynamicBoModelVo.getDynamicBoFieldDefinitionDoList();
            if (dynamicBoFieldDefinitionDOList != null) {
                List<org.jooq.Field> fields = new ArrayList<>();
                dynamicBoFieldDefinitionDOList.forEach(fieldDefinitionDo -> {
                    if (fieldDefinitionDo.getDbField()) {
//                        var basicType = fieldDefinitionDo.getBasicType();
                        // 创建jOOQ的字段类型，根据字段定义调整
//                        DataType<?> dataType = fieldDefinitionDo.getBasicType().getJooqDataType();
//                        if (fieldDefinitionDo.getDbFieldLength() != null && dataType.hasLength()) {
//                            dataType = dataType.length(fieldDefinitionDo.getDbFieldLength());
//                        }
//                        if (fieldDefinitionDo.getDbFieldPrecision() != null && dataType.hasPrecision()) {
//                            dataType = dataType.precision(fieldDefinitionDo.getDbFieldPrecision(), fieldDefinitionDo.getDbFieldScale());
//                        }
//                        if(fieldDefinitionDo.getDbFieldNullable()!=null) {
//                            dataType = dataType.nullable( fieldDefinitionDo.getDbFieldNullable());
//                        }
                        org.jooq.Field<?> jooqField = DynamicUtil.getJooqField(fieldDefinitionDo);
                         fields.add(jooqField);
                    }
                });
                List fieldList =   dbAuditFieldService.getAuditFields();
                fields.addAll(fieldList);
                org.jooq.Field<?>[] fieldArray = fields.toArray(new org.jooq.Field[0]);
                dbDatabaseService.createTable(dynamicBoModelVo.getDatabaseTableName(), fieldArray);
                boModelService.updateCreateTable(boModelCode, true);
            }
        } else {
            return ApiResult.fail("未找到对应的BO模型");
        }
        return ApiResult.ok();
    }

    @Override
    @Transactional
    public ApiResult<String> deleteBoModelDbTable(String boModelCode) {
        DynamicBoModelVo dynamicBoModelVo = boModelService.getBoModelVoByCode(boModelCode);
        if (dynamicBoModelVo != null) {
//            if (dynamicBoModelVo.getCreationTable()==null||dynamicBoModelVo.getCreationTable() == false) {
//                return ApiResult.fail("模型表未创建状态");
//            }
            //            List<DbTableDo> dbTableDo=dbMetadataService.getDbTableDo(dynamicBoModelVo.getDatabaseTableName());
//            if (dbTableDo==null||dbTableDo.size()==0){
//                return ApiResult.fail("模型表不存在"+dynamicBoModelVo.getDatabaseTableName());
//            }
            String tableName = dynamicBoModelVo.getDatabaseTableName();
            dbDatabaseService.dropTable(tableName);
            boModelService.updateCreateTable(boModelCode, false);
        } else {
            return ApiResult.fail("未找到对应的BO模型");
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<String> deleteAndCreatBoModelDbTable(String boModelCode) {
        try {
            ApiResult<String> apiResult=  deleteBoModelDbTable(boModelCode);
            if(apiResult.isSuccess()){
                return  createBoModelDbTable(boModelCode);
            }else{
                log.info(apiResult.getMsg());
                return apiResult;
            }
        }catch (Exception e){
            log.error("业务对象模型数据库操作异常："+e.getMessage());
            return ApiResult.fail("业务对象模型数据操作异常："+e.getMessage());
        }

    }

    @Override
    @Transactional
    public ApiResult<String> addBoModelDbField(String boModelCode,
                                               DynamicBoFieldDefinitionDO field) {
        DynamicBoModelVo dynamicBoModelVo = boModelService.getBoModelVoByCode(boModelCode);
        if (dynamicBoModelVo != null) {
//            if (dynamicBoModelVo.getCreationTable()==null||dynamicBoModelVo.getCreationTable() == false) {
//                return ApiResult.fail("模型表未创建状态");
//            }
            String tableName = dynamicBoModelVo.getDatabaseTableName();

            // 创建jOOQ的字段类型，根据字段定义调整
            org.jooq.Field<?> jooqField = DynamicUtil.getJooqField(field);

            try {
                dbDatabaseService.addField(tableName, jooqField);
            } catch (Exception e) {
                return ApiResult.fail("删除失败" + e.getMessage());
            }
        } else {
            return ApiResult.fail("未找到对应的BO模型");
        }
        return null;
    }



    @Override
    @Transactional
    public ApiResult<String> updateBoModelDbField(String boModelCode,
                                                  String fieldName,
                                                  BoFieldDefinitionUpdateParam newData) {
        DynamicBoModelVo dynamicBoModelVo = boModelService.getBoModelVoByCode(boModelCode);
        if (dynamicBoModelVo != null) {
//            if (dynamicBoModelVo.getCreationTable()==null||dynamicBoModelVo.getCreationTable() == false) {
//                return ApiResult.fail("模型表未创建状态");
//            }
            String tableName = dynamicBoModelVo.getDatabaseTableName();
            try {
                var newDataType = newData.getBasicType().getJooqDataType();
                dbDatabaseService.modifyField(tableName, fieldName, newDataType);
            } catch (Exception e) {
                return ApiResult.fail("删除失败" + e.getMessage());
            }
        } else {
            return ApiResult.fail("未找到对应的BO模型");
        }
        return null;
    }

    @Override
    @Transactional
    public ApiResult<String> deleteBoModelDbField(String boModelCode,
                                                  String fieldName) {
        DynamicBoModelVo dynamicBoModelVo = boModelService.getBoModelVoByCode(boModelCode);
        if (dynamicBoModelVo != null) {
//            if (dynamicBoModelVo.getCreationTable()==null||dynamicBoModelVo.getCreationTable() == false) {
//                return ApiResult.fail("模型表未创建状态");
//            }
            String tableName = dynamicBoModelVo.getDatabaseTableName();
            try {
                dbDatabaseService.dropTable(tableName);
            } catch (Exception e) {
                return ApiResult.fail("删除失败" + e.getMessage());
            }
        } else {
            return ApiResult.fail("未找到对应的BO模型");
        }
        return null;
    }


}