/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.PlatformAppProvider;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.common.ApproveTypeUdc;
import com.elitescloud.cloudt.lowcode.dynamic.common.DeployType;
import com.elitescloud.cloudt.lowcode.dynamic.common.ModelRelationTypeUdc;
import com.elitescloud.cloudt.lowcode.dynamic.common.WorkflowEngineStatusUdc;
import com.elitescloud.cloudt.lowcode.dynamic.convert.DynamicConfiguratorConvert;
import com.elitescloud.cloudt.lowcode.dynamic.model.bo.DynamicModelColumnBO;
import com.elitescloud.cloudt.lowcode.dynamic.model.bo.DynamicModelSimpleBO;
import com.elitescloud.cloudt.lowcode.dynamic.model.bo.DynamicModelTableBO;
import com.elitescloud.cloudt.lowcode.dynamic.model.bo.DynamicWorkflowCfgSimpleBO;
import com.elitescloud.cloudt.lowcode.dynamic.model.convert.BoModelFieldTypeEnum;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoModelDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicConfiguratorBoModelRelationDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicDeployModelRecordDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicDeployRecordDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.query.DynamicConfiguratorPageQueryVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.DynamicConfiguratorApprovalRespVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.DynamicConfiguratorBoFieldDetailRespVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.DynamicConfiguratorBoFieldListRespVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.DynamicConfiguratorBoModelDetailListRespVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.DynamicConfiguratorBoModelDetailRespVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.DynamicConfiguratorBoModelListRespVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.DynamicConfiguratorDetailRespVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.DynamicConfiguratorPageRespVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.DynamicDeployInfoRespVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.DynamicDeployRecordRespVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.save.DynamicBoFieldSaveVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.save.DynamicBoModelSaveVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.save.DynamicConfiguratorApprovalSaveVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.save.DynamicConfiguratorFormSaveVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.save.DynamicConfiguratorListPageSaveVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.save.DynamicConfiguratorPublishSaveVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.save.DynamicConfiguratorSaveVO;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DynamicBoFieldDefinitionRepoProc;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DynamicBoModelRepoProc;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DynamicConfigurationBoModelRelationRepoProc;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DynamicConfigurationRepoProc;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DynamicDeployModelRecordRepoProc;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DynamicDeployRecordRepoProc;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicConfigurationMngService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl.DynamicBoModelDeployService;
import com.elitescloud.cloudt.lowcode.dynamic.service.spi.DynamicWorkflowEngine;
import com.elitescloud.cloudt.lowcode.dynamic.service.spi.common.ProcDefInfo;
import com.elitescloud.cloudt.lowcode.dynamic.service.spi.common.WorkflowStatus;
import com.elitescloud.cloudt.system.cacheable.SysCacheMenuRpcService;
import com.elitescloud.cloudt.system.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.system.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.system.constant.PlatformMenusOuterLinkTypeEnum;
import com.elitescloud.cloudt.system.provider.SysMenuRpcService;
import com.elitescloud.cloudt.system.provider.dto.save.SysMenuSaveDTO;
import com.google.common.base.Functions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class DynamicConfigurationMngServiceImpl
extends BaseServiceImpl
implements DynamicConfigurationMngService {
    private static final Logger logger = LoggerFactory.getLogger(DynamicConfigurationMngServiceImpl.class);
    private static final Pattern PATTERN_DB_NAME = Pattern.compile("^[a-zA-Z0-9_]+$");
    @Autowired
    private DynamicConfigurationRepoProc repoProc;
    @Autowired
    private DynamicBoModelRepoProc boModelRepoProc;
    @Autowired
    private DynamicConfigurationBoModelRelationRepoProc modelRelationRepoProc;
    @Autowired
    private DynamicBoFieldDefinitionRepoProc boFieldRepoProc;
    @Autowired
    private DynamicDeployRecordRepoProc deployRecordRepoProc;
    @Autowired
    private DynamicDeployModelRecordRepoProc deployModelRecordRepoProc;
    @Autowired
    private PlatformAppProvider appProvider;
    @Autowired
    private SysCacheMenuRpcService cacheMenuRpcService;
    @Autowired
    private SysMenuRpcService menuRpcService;
    @Autowired
    private List<DynamicWorkflowEngine> workflowEngines;
    @Autowired
    private DynamicBoModelDeployService boModelDeployService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveDynamicConfigurator(DynamicConfiguratorSaveVO saveVO) {
        DynamicConfiguratorDO configuratorDO = null;
        try {
            configuratorDO = this.checkAndConvert(saveVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u529f\u80fd\u6a21\u5757\u6821\u9a8c\u5931\u8d25\uff1a", (Throwable)e);
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        this.repoProc.save((Serializable)((Object)configuratorDO));
        return ApiResult.ok((Object)configuratorDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> publishDynamicConfigurator(DynamicConfiguratorPublishSaveVO saveVO) {
        Assert.notNull((Object)saveVO.getId(), (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveVO.getAppCode(), (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveVO.getMenuCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        if (Boolean.TRUE.equals(this.repoProc.isPublished(saveVO.getId()))) {
            return ApiResult.fail((String)"\u8bf7\u5148\u53d6\u6d88\u53d1\u5e03");
        }
        this.repoProc.updatePublished(saveVO.getId(), saveVO.getAppCode(), saveVO.getMenuCode());
        this.publishMenu(saveVO);
        return ApiResult.ok((Object)saveVO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> revokePublishDynamicConfigurator(Long id) {
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        String menuCode = this.repoProc.getMenuCode(id);
        if (CharSequenceUtil.isBlank((CharSequence)menuCode)) {
            return ApiResult.ok((Object)id);
        }
        this.repoProc.revokePublish(id);
        this.revokeMenu(menuCode);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> deleteDynamicConfigurator(Long id) {
        if (Boolean.TRUE.equals(this.repoProc.isPublished(id))) {
            return ApiResult.fail((String)"\u8bf7\u5148\u53d6\u6d88\u53d1\u5e03");
        }
        if (Boolean.TRUE.equals(this.repoProc.isDeployed(id))) {
            return ApiResult.fail((String)"\u8bf7\u5148\u53d6\u6d88\u90e8\u7f72");
        }
        List<String> modelCodes = this.modelRelationRepoProc.getModelCodes(id);
        this.modelRelationRepoProc.deleteRelation(id, null);
        this.boModelRepoProc.deleteByBoModelCodes(modelCodes);
        this.deployRecordRepoProc.deleteByDynamicConfigurator(id);
        this.deployModelRecordRepoProc.deleteByDynamicConfigurator(id);
        this.repoProc.delete(id);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveBoModel(DynamicBoModelSaveVO saveVO) {
        DynamicBoModelDO boModelDO = null;
        try {
            boModelDO = this.checkAndConvert(saveVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u529f\u80fd\u7684\u6570\u636e\u6a21\u578b\u65f6\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        this.boModelRepoProc.save((Serializable)((Object)boModelDO));
        this.saveModelRelation(saveVO);
        return ApiResult.ok((Object)boModelDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> deleteBoModel(Long id, Long boModelId, Boolean deleteModel) {
        DynamicModelSimpleBO boModel;
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)boModelId, (String)"\u6a21\u578bID\u4e3a\u7a7a", (Object[])new Object[0]);
        if (deleteModel == null) {
            deleteModel = true;
        }
        if ((boModel = this.boModelRepoProc.getSimple(boModelId)) == null) {
            return ApiResult.ok((Object)id);
        }
        if (Boolean.TRUE.equals(boModel.getCreationTable())) {
            return ApiResult.fail((String)"\u8868\u5df2\u521b\u5efa\uff0c\u8bf7\u5148\u53d6\u6d88\u90e8\u7f72");
        }
        this.modelRelationRepoProc.deleteRelation(id, boModel.getBoModelCode());
        if (deleteModel.booleanValue()) {
            this.boModelRepoProc.delete(boModelId);
            this.boFieldRepoProc.deleteByBoModelId(boModelId);
        }
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addBoModelField(Long boModelId, DynamicBoFieldSaveVO fieldSaveVO) {
        DynamicBoFieldDefinitionDO boFieldDO = null;
        try {
            boFieldDO = this.checkAndConvert(boModelId, fieldSaveVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6570\u636e\u6a21\u578b\u5b57\u6bb5\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        this.boFieldRepoProc.save((Serializable)((Object)boFieldDO));
        return ApiResult.ok((Object)boFieldDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> deleteBoModelField(Long boFieldId) {
        Assert.notNull((Object)boFieldId, (String)"\u5b57\u6bb5ID\u4e3a\u7a7a", (Object[])new Object[0]);
        this.boFieldRepoProc.delete(boFieldId);
        return ApiResult.ok((Object)boFieldId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveBoModelFields(Long boModelId, List<DynamicBoFieldSaveVO> fieldSaveList) {
        Assert.notNull((Object)boModelId, (String)"\u6a21\u578bID\u4e3a\u7a7a", (Object[])new Object[0]);
        String boModelCode = this.boModelRepoProc.getCode(boModelId);
        Assert.notBlank((CharSequence)boModelCode, (String)"\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List<DynamicBoFieldDefinitionDO> boFieldDOList = null;
        try {
            boFieldDOList = this.checkAndConvert(boModelCode, fieldSaveList);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6570\u636e\u6a21\u578b\u5b57\u6bb5\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        List<Long> existsIds = this.boFieldRepoProc.getIdsByBoModelCode(boModelCode);
        if (CollUtil.isEmpty(boFieldDOList)) {
            if (!existsIds.isEmpty()) {
                this.boFieldRepoProc.delete(existsIds);
            }
            return ApiResult.ok((Object)boModelId);
        }
        if (!existsIds.isEmpty()) {
            List newIds = boFieldDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
            List toDelIds = existsIds.stream().filter(t -> !newIds.contains(t)).collect(Collectors.toList());
            if (!toDelIds.isEmpty()) {
                this.boFieldRepoProc.delete(toDelIds);
            }
        }
        this.boFieldRepoProc.save(boFieldDOList);
        return ApiResult.ok((Object)boModelId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveFormCfg(DynamicConfiguratorFormSaveVO formSaveVO) {
        Assert.notNull((Object)formSaveVO.getId(), (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, Object> formCfg = CollUtil.isEmpty(formSaveVO.getFormJson()) ? null : formSaveVO.getFormJson();
        this.repoProc.updateFormCfg(formSaveVO.getId(), formCfg);
        return ApiResult.ok((Object)formSaveVO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveListPageCfg(DynamicConfiguratorListPageSaveVO listPageSaveVO) {
        Assert.notNull((Object)listPageSaveVO.getId(), (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, Object> listPageCfg = CollUtil.isEmpty(listPageSaveVO.getListPageJson()) ? null : listPageSaveVO.getListPageJson();
        this.repoProc.updateListPageCfg(listPageSaveVO.getId(), listPageCfg);
        return ApiResult.ok((Object)listPageSaveVO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveApproval(DynamicConfiguratorApprovalSaveVO saveVO) {
        Assert.notNull((Object)saveVO.getConfiguratorId(), (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveVO.getApprovalType(), (String)"\u6d41\u7a0b\u5ba1\u6279\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        DynamicWorkflowCfgSimpleBO existsCfg = this.repoProc.getWorkflowCfgSimpleBO(saveVO.getConfiguratorId());
        Assert.notNull((Object)existsCfg, (String)"\u529f\u80fd\u6a21\u5757\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String approvalKey = null;
        if (saveVO.getProcDefInfo() != null) {
            approvalKey = saveVO.getProcDefInfo().getKey();
            saveVO.getProcDefInfo().setForm(true);
            saveVO.getProcDefInfo().setModuleCode(this.repoProc.getCode(saveVO.getConfiguratorId()));
            saveVO.getProcDefInfo().setModuleName(this.repoProc.getName(saveVO.getConfiguratorId()));
        }
        boolean created = !ApproveTypeUdc.EMPTY.getValue().equals(saveVO.getApprovalType());
        this.repoProc.updateApprovalCfg(saveVO.getConfiguratorId(), created, saveVO.getApprovalType(), saveVO.getApprovalEngine(), approvalKey, saveVO.getApprovalJson());
        if (StringUtils.hasText((String)saveVO.getApprovalEngine())) {
            boolean matched = false;
            for (DynamicWorkflowEngine workflowEngine : this.workflowEngines) {
                if (!saveVO.getApprovalEngine().equals(workflowEngine.engineType())) continue;
                matched = true;
                workflowEngine.createProcDef(saveVO.getProcDefInfo());
            }
            Assert.isTrue((boolean)matched, (String)"\u4fdd\u5b58\u6d41\u7a0b\u5931\u8d25", (Object[])new Object[0]);
        }
        return ApiResult.ok((Object)saveVO.getConfiguratorId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> deployApproval(Long id) {
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        DynamicWorkflowCfgSimpleBO bo = this.repoProc.getWorkflowCfgSimpleBO(id);
        Assert.notNull((Object)bo, (String)"\u529f\u80fd\u6a21\u5757\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.isTrue((boolean)Boolean.TRUE.equals(bo.getCreatedApproval()), (String)"\u672a\u521b\u5efa\u5de5\u4f5c\u6d41", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)bo.getApprovalEngine(), (String)"\u8bf7\u5148\u9009\u62e9\u5de5\u4f5c\u6d41\u5f15\u64ce", (Object[])new Object[0]);
        this.repoProc.updateDeployedApproval(id, true);
        boolean matched = false;
        for (DynamicWorkflowEngine workflowEngine : this.workflowEngines) {
            if (!workflowEngine.engineType().equals(bo.getApprovalEngine())) continue;
            workflowEngine.deploy(bo.getApprovalKey());
            matched = true;
            break;
        }
        if (!matched) {
            throw new BusinessException("\u672a\u627e\u5230\u5de5\u4f5c\u6d41\u5f15\u64ce" + bo.getApprovalEngine());
        }
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> deleteApproval(Long id) {
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        DynamicWorkflowCfgSimpleBO bo = this.repoProc.getWorkflowCfgSimpleBO(id);
        Assert.notNull((Object)bo, (String)"\u529f\u80fd\u6a21\u5757\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.isTrue((boolean)Boolean.TRUE.equals(bo.getCreatedApproval()), (String)"\u672a\u521b\u5efa\u5de5\u4f5c\u6d41", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)bo.getApprovalEngine(), (String)"\u8bf7\u5148\u9009\u62e9\u5de5\u4f5c\u6d41\u5f15\u64ce", (Object[])new Object[0]);
        Boolean published = this.repoProc.getPublished(id);
        Assert.isTrue((boolean)Boolean.FALSE.equals(published), (String)"\u529f\u80fd\u5df2\u53d1\u5e03\uff0c\u4e0d\u53ef\u5220\u9664\u6d41\u7a0b", (Object[])new Object[0]);
        this.repoProc.deleteApproval(id);
        boolean matched = false;
        for (DynamicWorkflowEngine workflowEngine : this.workflowEngines) {
            if (!workflowEngine.engineType().equals(bo.getApprovalEngine())) continue;
            workflowEngine.deleteProcDef(bo.getApprovalKey());
            matched = true;
            break;
        }
        if (!matched) {
            throw new BusinessException("\u672a\u627e\u5230\u5de5\u4f5c\u6d41\u5f15\u64ce" + bo.getApprovalEngine());
        }
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> deploy(Long id) {
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        this.deploy(id, DeployType.DEPLOY);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> redeploy(Long id) {
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        this.deploy(id, DeployType.REDEPLOY);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> cancelDeploy(Long id) {
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        this.deploy(id, DeployType.CANCEL_DEPLOY);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<DynamicConfiguratorDetailRespVO> getDynamicConfigurator(Long id) {
        List menus;
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        DynamicConfiguratorDO configuratorDO = (DynamicConfiguratorDO)((Object)this.repoProc.get(id));
        if (configuratorDO == null) {
            return ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        DynamicConfiguratorDetailRespVO respVO = DynamicConfiguratorConvert.INSTANCE.do2DetailRespVO(configuratorDO);
        respVO.setApprovalTypeName(super.udcValue((BaseUdc)new ApproveTypeUdc("approveType", respVO.getApprovalType())));
        if (StringUtils.hasText((String)respVO.getAppCode())) {
            Map<String, String> appMap = this.appProvider.all().stream().collect(Collectors.toMap(CodeNameParam::getCode, CodeNameParam::getName, (t1, t2) -> t1));
            respVO.setAppName(appMap.get(respVO.getAppCode()));
        }
        if (StringUtils.hasText((String)respVO.getMenuCode()) && CollUtil.isNotEmpty((Collection)(menus = this.cacheMenuRpcService.getMenuWithParents(respVO.getMenuCode())))) {
            respVO.setMenus(menus);
            respVO.setMenuName(((IdCodeNameParam)menus.get(menus.size() - 1)).getName());
        }
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<PagingVO<DynamicConfiguratorPageRespVO>> pageQuery(DynamicConfiguratorPageQueryVO queryVO) {
        PagingVO<DynamicConfiguratorPageRespVO> pageData = this.repoProc.pageMng(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok(pageData);
        }
        Map approvalTypeMap = super.udcMap((BaseUdc)ApproveTypeUdc.EMPTY);
        Map<String, String> appMap = this.appProvider.all().stream().collect(Collectors.toMap(CodeNameParam::getCode, CodeNameParam::getName, (t1, t2) -> t1));
        pageData.each(t -> {
            List menus;
            t.setApprovalTypeName((String)approvalTypeMap.get(t.getApprovalType()));
            t.setAppName((String)appMap.get(t.getAppCode()));
            if (StringUtils.hasText((String)t.getMenuCode()) && CollUtil.isNotEmpty((Collection)(menus = this.cacheMenuRpcService.getMenuWithParents(t.getMenuCode())))) {
                t.setMenus(menus);
                t.setMenuName(((IdCodeNameParam)menus.get(menus.size() - 1)).getName());
            }
        });
        return ApiResult.ok(pageData);
    }

    @Override
    public ApiResult<List<DynamicConfiguratorBoModelListRespVO>> listBoModel(Long id) {
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        List<DynamicConfiguratorBoModelListRespVO> respVoList = this.modelRelationRepoProc.listBoModelRelation(id);
        return ApiResult.ok(respVoList);
    }

    @Override
    public ApiResult<List<DynamicConfiguratorBoModelDetailListRespVO>> listBoModelDetail(Long id) {
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        List<DynamicConfiguratorBoModelDetailListRespVO> respVoList = this.modelRelationRepoProc.listBoModelDetail(id);
        if (CollUtil.isEmpty(respVoList)) {
            return ApiResult.ok(respVoList);
        }
        Map<String, List<DynamicConfiguratorBoFieldDetailRespVO>> fieldsMap = this.boFieldRepoProc.listByConfiguratorId(id).stream().map(t -> {
            DynamicConfiguratorBoFieldDetailRespVO respVO = DynamicConfiguratorConvert.INSTANCE.do2DetailRespVO((DynamicBoFieldDefinitionDO)((Object)t));
            respVO.setBoFieldId(t.getId());
            respVO.setBoModelCode(t.getBasicModuleCode());
            return respVO;
        }).sorted(Comparator.comparing(DynamicConfiguratorBoFieldDetailRespVO::getBasicDisplayOrder, Comparator.nullsLast(Integer::compareTo))).collect(Collectors.groupingBy(DynamicConfiguratorBoFieldDetailRespVO::getBoModelCode));
        for (DynamicConfiguratorBoModelDetailListRespVO respVO : respVoList) {
            respVO.setFieldList(fieldsMap.getOrDefault(respVO.getBoModelCode(), Collections.emptyList()));
        }
        return ApiResult.ok(respVoList);
    }

    @Override
    public ApiResult<DynamicConfiguratorBoModelDetailRespVO> getBoModel(Long id, Long boModelId) {
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)boModelId, (String)"\u6570\u636e\u6a21\u578bID\u4e3a\u7a7a", (Object[])new Object[0]);
        DynamicModelSimpleBO modelBO = this.boModelRepoProc.getSimple(boModelId);
        if (modelBO == null) {
            return ApiResult.fail((String)"\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728");
        }
        DynamicConfiguratorBoModelRelationDO modelRelationDO = this.modelRelationRepoProc.getBoModelRelation(id, modelBO.getBoModelCode());
        if (modelRelationDO == null) {
            return ApiResult.fail((String)"\u6570\u636e\u6a21\u578b\u5173\u7cfb\u4e0d\u5b58\u5728");
        }
        DynamicConfiguratorBoModelDetailRespVO respVO = new DynamicConfiguratorBoModelDetailRespVO();
        respVO.setConfiguratorId(id);
        respVO.setBoModelCode(modelBO.getBoModelCode());
        respVO.setBoModeName(modelBO.getBoModeName());
        respVO.setBoModelType(modelRelationDO.getBoModelType());
        respVO.setBoModelTypeName(modelBO.getDescription());
        respVO.setDescription(modelRelationDO.getBoModelCode());
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<List<DynamicConfiguratorBoFieldListRespVO>> getBoFieldList(Long boModelId) {
        Assert.notNull((Object)boModelId, (String)"\u6570\u636e\u6a21\u578bID\u4e3a\u7a7a", (Object[])new Object[0]);
        List respVoList = this.boFieldRepoProc.listByBoModelId(boModelId).stream().sorted(Comparator.comparing(DynamicBoFieldDefinitionDO::getBasicDisplayOrder, Comparator.nullsLast(Integer::compareTo))).map(t -> {
            DynamicConfiguratorBoFieldListRespVO respVO = DynamicConfiguratorConvert.INSTANCE.do2ListRespVO((DynamicBoFieldDefinitionDO)((Object)t));
            respVO.setBoFieldId(t.getId());
            return respVO;
        }).collect(Collectors.toList());
        return ApiResult.ok(respVoList);
    }

    @Override
    public ApiResult<DynamicConfiguratorBoFieldDetailRespVO> getBoFieldDetail(Long boFieldId) {
        Assert.notNull((Object)boFieldId, (String)"\u5b57\u6bb5ID\u4e3a\u7a7a", (Object[])new Object[0]);
        DynamicBoFieldDefinitionDO fieldDO = (DynamicBoFieldDefinitionDO)((Object)this.boFieldRepoProc.get(boFieldId));
        if (fieldDO == null) {
            return ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        DynamicConfiguratorBoFieldDetailRespVO respVO = DynamicConfiguratorConvert.INSTANCE.do2DetailRespVO(fieldDO);
        respVO.setBoFieldId(fieldDO.getId());
        respVO.setBoModelCode(fieldDO.getBasicModuleCode());
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<Map<String, Object>> getFormCfg(Long id) {
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, Object> formCfg = this.repoProc.getFormJson(id);
        return ApiResult.ok((Object)((Map)ObjUtil.defaultIfNull(formCfg, Collections.emptyMap())));
    }

    @Override
    public ApiResult<Map<String, Object>> getListPageCfg(Long id) {
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, Object> listPageCfg = this.repoProc.getListPageJson(id);
        return ApiResult.ok((Object)((Map)ObjUtil.defaultIfNull(listPageCfg, Collections.emptyMap())));
    }

    @Override
    public ApiResult<DynamicConfiguratorApprovalRespVO> getApprovalInfo(Long id) {
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        DynamicWorkflowCfgSimpleBO cfgBO = this.repoProc.getWorkflowCfgSimpleBO(id);
        Assert.notNull((Object)cfgBO, (String)"\u529f\u80fd\u6a21\u5757\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        DynamicConfiguratorApprovalRespVO respVO = new DynamicConfiguratorApprovalRespVO();
        respVO.setCreatedApproval(Boolean.TRUE.equals(cfgBO.getCreatedApproval()));
        respVO.setApprovalType(cfgBO.getApprovalType());
        if (StringUtils.hasText((String)cfgBO.getApprovalType())) {
            respVO.setApprovalTypeName(super.udcValue((BaseUdc)new ApproveTypeUdc(cfgBO.getApprovalType())));
        }
        if (StringUtils.hasText((String)cfgBO.getApprovalEngine())) {
            respVO.setApprovalEngine(cfgBO.getApprovalEngine());
            boolean engineMatched = false;
            for (DynamicWorkflowEngine workflowEngine : this.workflowEngines) {
                if (!cfgBO.getApprovalEngine().equals(workflowEngine.engineType())) continue;
                engineMatched = true;
                respVO.setApprovalEngineName(workflowEngine.engineName());
                if (!StringUtils.hasText((String)cfgBO.getApprovalKey())) continue;
                try {
                    respVO.setProcDefInfo(workflowEngine.getProcDefInfo(cfgBO.getApprovalKey()));
                    respVO.setEngineState(WorkflowEngineStatusUdc.RUNNING.getValue());
                    respVO.setEngineStateName(super.udcValue((BaseUdc)new WorkflowEngineStatusUdc(WorkflowEngineStatusUdc.RUNNING.getValue())));
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u5f02\u5e38\uff1a{}", (Object)cfgBO.getApprovalKey(), (Object)e);
                    respVO.setEngineState(WorkflowEngineStatusUdc.CONNECTION_EXP.getValue());
                    respVO.setEngineStateName(super.udcValue((BaseUdc)new WorkflowEngineStatusUdc(WorkflowEngineStatusUdc.CONNECTION_EXP.getValue())));
                    respVO.setEngineExpMsg(e.getMessage());
                }
            }
            Assert.isTrue((boolean)engineMatched, (String)("\u672a\u77e5\u6d41\u7a0b\u5f15\u64ce\u7c7b\u578b" + cfgBO.getApprovalEngine()), (Object[])new Object[0]);
        }
        respVO.setApprovalKey(cfgBO.getApprovalKey());
        respVO.setApprovalJson(cfgBO.getApprovalJson());
        if (respVO.getProcDefInfo() == null) {
            respVO.setCreatedApproval(false);
            respVO.setProcDefInfo(new ProcDefInfo());
            respVO.getProcDefInfo().setAppPrefixUrl("http://cloudt-system");
        } else {
            respVO.setCreatedApproval(true);
        }
        if (CharSequenceUtil.isBlank((CharSequence)respVO.getProcDefInfo().getModuleCode())) {
            respVO.getProcDefInfo().setModuleCode(this.repoProc.getCode(id));
        }
        if (CharSequenceUtil.isBlank((CharSequence)respVO.getProcDefInfo().getModuleName())) {
            respVO.getProcDefInfo().setModuleName(this.repoProc.getName(id));
        }
        if (CharSequenceUtil.isBlank((CharSequence)respVO.getProcDefInfo().getName())) {
            respVO.getProcDefInfo().setName(respVO.getProcDefInfo().getName() + "\u5ba1\u6279");
        }
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<List<CodeNameParam>> getApprovalEngineList() {
        List engineList = this.workflowEngines.stream().map(t -> new CodeNameParam(t.engineType(), t.engineName())).collect(Collectors.toList());
        return ApiResult.ok(engineList);
    }

    @Override
    public ApiResult<WorkflowStatus> getApprovalEngineStatus(String engineType) {
        Assert.notBlank((CharSequence)engineType, (String)"\u5de5\u4f5c\u6d41\u5f15\u64ce\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        for (DynamicWorkflowEngine workflowEngine : this.workflowEngines) {
            if (!engineType.equals(workflowEngine.engineType())) continue;
            return ApiResult.ok((Object)workflowEngine.getEngineStatus());
        }
        return ApiResult.fail((String)"\u672a\u77e5\u5de5\u4f5c\u6d41\u5f15\u64ce\u7c7b\u578b");
    }

    @Override
    public ApiResult<DynamicDeployInfoRespVO> getDeployInfo(Long id) {
        Assert.notNull((Object)id, (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        DynamicDeployInfoRespVO respVO = new DynamicDeployInfoRespVO();
        respVO.setDeployed(this.repoProc.getDeploy(id));
        Map<Long, List<DynamicDeployModelRecordDO>> modelRecordsMap = this.deployModelRecordRepoProc.listByConfigurator(id).stream().collect(Collectors.groupingBy(DynamicDeployModelRecordDO::getRecordId));
        List<DynamicDeployRecordRespVO> recordList = this.deployRecordRepoProc.listByDynamicConfigurator(id).stream().sorted(Comparator.comparing(DynamicDeployRecordDO::getStartTime).reversed()).map(t -> {
            DynamicDeployRecordRespVO recordRespVO = new DynamicDeployRecordRespVO();
            recordRespVO.setId(t.getId());
            recordRespVO.setDeployType(t.getDeployType());
            recordRespVO.setStartTime(t.getStartTime());
            recordRespVO.setFinishTime(t.getFinishTime());
            recordRespVO.setSuccess(t.getSuccess());
            if (t.getFinished() == null || !t.getFinished().booleanValue()) {
                recordRespVO.setResult("\u8fdb\u884c\u4e2d");
            } else {
                recordRespVO.setResult(Boolean.TRUE.equals(t.getSuccess()) ? "\u6210\u529f" : "\u5931\u8d25");
            }
            recordRespVO.setCreator(t.getCreator());
            recordRespVO.setLog(modelRecordsMap.getOrDefault(t.getId(), Collections.emptyList()).stream().map(DynamicDeployModelRecordDO::getPrettyLogJson).collect(Collectors.joining(";")));
            return recordRespVO;
        }).collect(Collectors.toList());
        respVO.setRecordList(recordList);
        return ApiResult.ok((Object)respVO);
    }

    private void deploy(long id, DeployType deployType) {
        String configuratorCode = this.repoProc.getCode(id);
        Assert.notBlank((CharSequence)configuratorCode, (String)"\u529f\u80fd\u6a21\u5757\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List<DynamicModelTableBO> tableList = this.queryTablesByDynamicCode(configuratorCode);
        Assert.notEmpty(tableList, (String)"\u8bf7\u5148\u914d\u7f6e\u6570\u636e\u6a21\u578b", (Object[])new Object[0]);
        this.boModelDeployService.deploy(deployType, tableList, configuratorCode);
    }

    private List<DynamicModelTableBO> queryTablesByDynamicCode(String dynamicConfiguratorCode) {
        List<DynamicModelTableBO> tableList = this.modelRelationRepoProc.listModelTableByConfiguratorCode(dynamicConfiguratorCode);
        if (tableList.isEmpty()) {
            return tableList;
        }
        Set<String> boModelCodes = tableList.stream().map(DynamicModelTableBO::getBoModelCode).collect(Collectors.toSet());
        Map<String, List<DynamicModelColumnBO>> columnsMap = this.boFieldRepoProc.listColumnBO(boModelCodes).stream().collect(Collectors.groupingBy(DynamicModelColumnBO::getBasicModuleCode));
        for (DynamicModelTableBO tableBO : tableList) {
            if (!columnsMap.containsKey(tableBO.getBoModelCode())) continue;
            List<DynamicModelColumnBO> columnList = columnsMap.get(tableBO.getBoModelCode()).stream().sorted(Comparator.comparing(DynamicModelColumnBO::getBasicDisplayOrder, Comparator.nullsLast(Integer::compareTo))).collect(Collectors.toList());
            tableBO.setColumnList(columnList);
            this.addBaseColumns(columnList);
        }
        return tableList.stream().filter(t -> CollUtil.isNotEmpty(t.getColumnList())).collect(Collectors.toList());
    }

    private void addBaseColumns(List<DynamicModelColumnBO> columns) {
        Map columnsMap = columns.stream().collect(Collectors.toMap(DynamicModelColumnBO::getBasicKey, Functions.identity(), (t1, t2) -> t1));
        List<DynamicModelColumnBO> baseColumns = this.getBaseColumns();
        for (DynamicModelColumnBO baseColumn : baseColumns) {
            if (columnsMap.containsKey(baseColumn.getBasicKey())) continue;
            if ("id".equals(baseColumn.getBasicKey())) {
                columns.add(0, baseColumn);
                continue;
            }
            columns.add(baseColumn);
        }
    }

    private List<DynamicModelColumnBO> getBaseColumns() {
        ArrayList<DynamicModelColumnBO> columns = new ArrayList<DynamicModelColumnBO>(16);
        DynamicModelColumnBO id = new DynamicModelColumnBO();
        id.setBasicKey("id");
        id.setBasicName("\u4e3b\u952e");
        id.setBasicType(BoModelFieldTypeEnum.LONG);
        id.setPrimaryKey(true);
        id.setDbFieldNullable(false);
        id.setDbFieldUnique(true);
        id.setDbFieldIndex(false);
        columns.add(id);
        DynamicModelColumnBO tenantId = new DynamicModelColumnBO();
        tenantId.setBasicKey("tenant_id");
        tenantId.setBasicName("\u79df\u6237ID");
        tenantId.setBasicType(BoModelFieldTypeEnum.LONG);
        tenantId.setBasicDefaultValue(TenantConstant.DEFAULT_TENANT_ID.toString());
        tenantId.setDbFieldNullable(false);
        columns.add(tenantId);
        DynamicModelColumnBO belongOrgId = new DynamicModelColumnBO();
        belongOrgId.setBasicKey("belong_org_id");
        belongOrgId.setBasicName("\u6240\u5c5e\u7ec4\u7ec7ID");
        belongOrgId.setBasicType(BoModelFieldTypeEnum.LONG);
        columns.add(belongOrgId);
        DynamicModelColumnBO tenantOrgId = new DynamicModelColumnBO();
        tenantOrgId.setBasicKey("tenant_org_id");
        tenantOrgId.setBasicName("\u79df\u6237\u7ec4\u7ec7ID");
        tenantOrgId.setBasicType(BoModelFieldTypeEnum.LONG);
        columns.add(tenantOrgId);
        DynamicModelColumnBO remark = new DynamicModelColumnBO();
        remark.setBasicKey("remark");
        remark.setBasicName("\u5907\u6ce8");
        remark.setBasicType(BoModelFieldTypeEnum.STRING);
        columns.add(remark);
        DynamicModelColumnBO createUserId = new DynamicModelColumnBO();
        createUserId.setBasicKey("create_user_id");
        createUserId.setBasicName("\u8bb0\u5f55\u521b\u5efa\u8005");
        createUserId.setBasicType(BoModelFieldTypeEnum.LONG);
        columns.add(createUserId);
        DynamicModelColumnBO creator = new DynamicModelColumnBO();
        creator.setBasicKey("creator");
        creator.setBasicName("\u8bb0\u5f55\u521b\u5efa\u8005");
        creator.setBasicType(BoModelFieldTypeEnum.STRING);
        columns.add(creator);
        DynamicModelColumnBO createTime = new DynamicModelColumnBO();
        createTime.setBasicKey("create_time");
        createTime.setBasicName("\u8bb0\u5f55\u521b\u5efa\u65f6\u95f4");
        createTime.setBasicType(BoModelFieldTypeEnum.DATE_TIME);
        columns.add(createTime);
        DynamicModelColumnBO modifyUserId = new DynamicModelColumnBO();
        modifyUserId.setBasicKey("modify_user_id");
        modifyUserId.setBasicName("\u8bb0\u5f55\u6700\u540e\u66f4\u65b0\u8005ID");
        modifyUserId.setBasicType(BoModelFieldTypeEnum.LONG);
        columns.add(modifyUserId);
        DynamicModelColumnBO updater = new DynamicModelColumnBO();
        updater.setBasicKey("updater");
        updater.setBasicName("\u8bb0\u5f55\u6700\u540e\u66f4\u65b0\u8005");
        updater.setBasicType(BoModelFieldTypeEnum.STRING);
        columns.add(updater);
        DynamicModelColumnBO modifyTime = new DynamicModelColumnBO();
        modifyTime.setBasicKey("modify_time");
        modifyTime.setBasicName("\u8bb0\u5f55\u6700\u540e\u66f4\u65b0\u65f6\u95f4");
        modifyTime.setBasicType(BoModelFieldTypeEnum.DATE_TIME);
        columns.add(modifyTime);
        DynamicModelColumnBO deleteFlag = new DynamicModelColumnBO();
        deleteFlag.setBasicKey("delete_flag");
        deleteFlag.setBasicName("\u5220\u9664\u6807\u8bb0");
        deleteFlag.setBasicType(BoModelFieldTypeEnum.INTEGER);
        deleteFlag.setBasicDefaultValue("0");
        deleteFlag.setDbFieldNullable(false);
        columns.add(deleteFlag);
        DynamicModelColumnBO auditDataVersion = new DynamicModelColumnBO();
        auditDataVersion.setBasicKey("audit_data_version");
        auditDataVersion.setBasicName("\u9501\u7248\u672c");
        auditDataVersion.setBasicType(BoModelFieldTypeEnum.INTEGER);
        auditDataVersion.setBasicDefaultValue("0");
        auditDataVersion.setDbFieldNullable(false);
        columns.add(auditDataVersion);
        DynamicModelColumnBO secBuId = new DynamicModelColumnBO();
        secBuId.setBasicKey("sec_bu_Id");
        secBuId.setBasicName("\u6570\u636e\u5f52\u5c5e\u7ec4\u7ec7id");
        secBuId.setBasicType(BoModelFieldTypeEnum.LONG);
        columns.add(secBuId);
        DynamicModelColumnBO secUserId = new DynamicModelColumnBO();
        secUserId.setBasicKey("sec_user_id");
        secUserId.setBasicName("\u6570\u636e\u5f52\u5c5e\u96c7\u5458id");
        secUserId.setBasicType(BoModelFieldTypeEnum.LONG);
        columns.add(secUserId);
        DynamicModelColumnBO secOuId = new DynamicModelColumnBO();
        secOuId.setBasicKey("sec_ou_id");
        secOuId.setBasicName("\u6570\u636e\u5f52\u5c5e\u516c\u53f8id");
        secOuId.setBasicType(BoModelFieldTypeEnum.LONG);
        columns.add(secOuId);
        return columns;
    }

    private DynamicConfiguratorDO checkAndConvert(DynamicConfiguratorSaveVO saveVO) {
        DynamicConfiguratorDO configuratorDO = saveVO.getId() == null ? new DynamicConfiguratorDO() : (DynamicConfiguratorDO)((Object)this.repoProc.get(saveVO.getId()));
        Assert.notNull((Object)((Object)configuratorDO), (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveVO.getDynamicConfiguratorCode(), (String)"\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        if (saveVO.getId() != null) {
            Assert.isTrue((boolean)saveVO.getDynamicConfiguratorCode().equals(configuratorDO.getDynamicConfiguratorCode()), (String)"\u7f16\u7801\u4e0d\u53ef\u4fee\u6539", (Object[])new Object[0]);
        }
        boolean exists = this.repoProc.existsCode(saveVO.getDynamicConfiguratorCode(), saveVO.getId());
        Assert.isFalse((boolean)exists, (String)"\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        DynamicConfiguratorConvert.INSTANCE.saveVo2DO(saveVO, configuratorDO);
        if (CharSequenceUtil.isBlank((CharSequence)saveVO.getApprovalType())) {
            configuratorDO.setApprovalType(ApproveTypeUdc.EMPTY.getValue());
        }
        ObjUtil.ifNull((Object)configuratorDO.getApprovalKey(), (Object)"", configuratorDO::setApprovalKey);
        return configuratorDO;
    }

    private DynamicBoModelDO checkAndConvert(DynamicBoModelSaveVO saveVO) {
        DynamicBoModelDO boModelDO = saveVO.getBoModelId() == null ? new DynamicBoModelDO() : (DynamicBoModelDO)((Object)this.boModelRepoProc.get(saveVO.getBoModelId()));
        Assert.notNull((Object)((Object)boModelDO), (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        boolean exists = false;
        Assert.notBlank((CharSequence)saveVO.getBoModelCode(), (String)"\u6a21\u578b\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)this.validateDbName(saveVO.getBoModelCode()), (String)"\u6a21\u578b\u7f16\u7801\u53ea\u80fd\u662f\u7531\u5b57\u6bcd\u3001\u4e0b\u5212\u7ebf\u548c\u6570\u5b57\u7ec4\u6210\uff0c\u4e14\u957f\u5ea6\u4e0d\u8d85\u8fc720", (Object[])new Object[0]);
        if (!saveVO.getBoModelCode().equalsIgnoreCase(boModelDO.getBoModelCode())) {
            if (saveVO.getBoModelId() != null) {
                throw new BusinessException("\u7f16\u7801\u4e0d\u53ef\u4fee\u6539");
            }
            exists = (Boolean)this.tenantDataIsolateProvider.byNone(() -> this.boModelRepoProc.existsCode(saveVO.getBoModelCode(), saveVO.getBoModelId()));
            Assert.isFalse((boolean)exists, (String)"\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
        DynamicConfiguratorConvert.INSTANCE.copyVo2DO(saveVO, boModelDO);
        if (boModelDO.getCreationTable() == null) {
            boModelDO.setCreationTable(false);
        }
        if (!boModelDO.getCreationTable().booleanValue()) {
            boModelDO.setDatabaseTableName("dynamically_" + boModelDO.getBoModelCode());
        }
        return boModelDO;
    }

    private DynamicBoFieldDefinitionDO checkAndConvert(Long boModelId, DynamicBoFieldSaveVO saveVO) {
        Assert.notNull((Object)boModelId, (String)"\u6a21\u578bID\u4e3a\u7a7a", (Object[])new Object[0]);
        DynamicBoFieldDefinitionDO boFieldDO = saveVO.getBoFieldId() == null ? new DynamicBoFieldDefinitionDO() : (DynamicBoFieldDefinitionDO)((Object)this.boFieldRepoProc.get(saveVO.getBoFieldId()));
        Assert.notNull((Object)((Object)boFieldDO), (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String boModelCode = StringUtils.hasText((String)boFieldDO.getBasicModuleCode()) ? boFieldDO.getBasicModuleCode() : this.boModelRepoProc.getCode(boModelId);
        Assert.notBlank((CharSequence)boModelCode, (String)"\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveVO.getBasicKey(), (String)"\u5b57\u6bb5\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)this.validateDbName(saveVO.getBasicKey()), (String)"\u5b57\u6bb5\u6807\u8bc6\u53ea\u80fd\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u4e14\u957f\u5ea6\u4e0d\u8d85\u8fc720", (Object[])new Object[0]);
        if (StringUtils.hasText((String)saveVO.getBasicKeyAs()) && !this.validateDbName(saveVO.getBasicKeyAs())) {
            throw new IllegalArgumentException("\u5b57\u6bb5\u6807\u8bc6\u522b\u540d\u53ea\u80fd\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u4e14\u957f\u5ea6\u4e0d\u8d85\u8fc720");
        }
        if (!saveVO.getBasicKey().equals(boFieldDO.getBasicKey())) {
            List<String> basicKeys = this.boFieldRepoProc.getBasicKeys(boModelCode);
            Assert.isFalse((boolean)basicKeys.contains(saveVO.getBasicKey()), (String)"\u5b57\u6bb5\u6807\u8bc6\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
        Assert.notNull((Object)((Object)saveVO.getBasicType()), (String)"\u5b57\u6bb5\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        if (saveVO.getDbFieldPrecision() != null && saveVO.getDbFieldScale() != null) {
            Assert.isTrue((saveVO.getDbFieldPrecision() >= saveVO.getDbFieldScale() ? 1 : 0) != 0, (String)"\u5c0f\u6570\u90e8\u5206\u4f4d\u6570\u4e0d\u80fd\u5c0f\u4e8e\u5c0f\u6570\u603b\u4f4d\u6570", (Object[])new Object[0]);
        }
        DynamicConfiguratorConvert.INSTANCE.copyVo2DO(saveVO, boFieldDO);
        boFieldDO.setBasicModuleCode(boModelCode);
        if (boFieldDO.getBasicDisplayOrder() == null) {
            boFieldDO.setBasicDisplayOrder((Integer)ObjUtil.defaultIfNull((Object)this.boFieldRepoProc.getMaxSortNo(boModelCode), (Object)0) + 1);
        }
        ObjUtil.ifNull((Object)saveVO.getDbField(), (Object)true, boFieldDO::setDbField);
        ObjUtil.ifNull((Object)saveVO.getBasicState(), (Object)true, boFieldDO::setBasicState);
        return boFieldDO;
    }

    private List<DynamicBoFieldDefinitionDO> checkAndConvert(String boModelCode, List<DynamicBoFieldSaveVO> saveVoList) {
        Assert.notBlank((CharSequence)boModelCode, (String)"\u6a21\u578b\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollUtil.isEmpty(saveVoList)) {
            return Collections.emptyList();
        }
        List existIds = saveVoList.stream().map(DynamicBoFieldSaveVO::getBoFieldId).filter(Objects::nonNull).collect(Collectors.toList());
        Map existsFieldDoMap = existIds.isEmpty() ? Collections.emptyMap() : this.boFieldRepoProc.get(existIds).stream().collect(Collectors.toMap(BaseModel::getId, Functions.identity(), (t1, t2) -> t1));
        ArrayList<DynamicBoFieldDefinitionDO> fieldDoList = new ArrayList<DynamicBoFieldDefinitionDO>(saveVoList.size());
        HashSet<String> existsBasicKeys = new HashSet<String>(saveVoList.size());
        DynamicBoFieldDefinitionDO fieldDO = null;
        int index = 0;
        for (DynamicBoFieldSaveVO saveVO : saveVoList) {
            fieldDO = saveVO.getBoFieldId() == null ? new DynamicBoFieldDefinitionDO() : (DynamicBoFieldDefinitionDO)((Object)existsFieldDoMap.get(saveVO.getBoFieldId()));
            Assert.notNull((Object)((Object)fieldDO), (String)"\u5b58\u5728\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)saveVO.getBasicKey(), (String)"\u5b57\u6bb5\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isTrue((boolean)this.validateDbName(saveVO.getBasicKey()), (String)"\u5b57\u6bb5\u6807\u8bc6\u53ea\u80fd\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u4e14\u957f\u5ea6\u4e0d\u8d85\u8fc720", (Object[])new Object[0]);
            if (StringUtils.hasText((String)saveVO.getBasicKeyAs()) && !this.validateDbName(saveVO.getBasicKeyAs())) {
                throw new IllegalArgumentException("\u5b57\u6bb5\u6807\u8bc6\u522b\u540d\u53ea\u80fd\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u4e14\u957f\u5ea6\u4e0d\u8d85\u8fc720");
            }
            Assert.isFalse((boolean)existsBasicKeys.contains(saveVO.getBasicKey()), (String)("\u5b57\u6bb5\u6807\u8bc6" + saveVO.getBasicKey() + "\u5df2\u5b58\u5728"), (Object[])new Object[0]);
            existsBasicKeys.add(saveVO.getBasicKey());
            Assert.notNull((Object)((Object)saveVO.getBasicType()), (String)"\u5b57\u6bb5\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
            if (saveVO.getDbFieldPrecision() != null && saveVO.getDbFieldScale() != null) {
                Assert.isTrue((saveVO.getDbFieldPrecision() >= saveVO.getDbFieldScale() ? 1 : 0) != 0, (String)"\u5c0f\u6570\u90e8\u5206\u4f4d\u6570\u4e0d\u80fd\u5c0f\u4e8e\u5c0f\u6570\u603b\u4f4d\u6570", (Object[])new Object[0]);
            }
            DynamicConfiguratorConvert.INSTANCE.copyVo2DO(saveVO, fieldDO);
            fieldDO.setBasicModuleCode(boModelCode);
            fieldDO.setBasicDisplayOrder(index++);
            ObjUtil.ifNull((Object)saveVO.getDbField(), (Object)true, fieldDO::setDbField);
            ObjUtil.ifNull((Object)saveVO.getBasicState(), (Object)true, fieldDO::setBasicState);
            fieldDoList.add(fieldDO);
        }
        return fieldDoList;
    }

    private Long saveModelRelation(DynamicBoModelSaveVO saveVO) {
        DynamicConfiguratorBoModelRelationDO boModelRelationDO;
        Assert.notNull((Object)saveVO.getConfiguratorId(), (String)"\u529f\u80fd\u6a21\u5757ID\u4e3a\u7a7a", (Object[])new Object[0]);
        String configuratorCode = this.repoProc.getCode(saveVO.getConfiguratorId());
        Assert.notBlank((CharSequence)configuratorCode, (String)"\u529f\u80fd\u6a21\u5757\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveVO.getBoModelType(), (String)"\u5173\u7cfb\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> primaryCodes = this.modelRelationRepoProc.getPrimaryModelCodes(configuratorCode);
        if (ModelRelationTypeUdc.PRIMARY.getValue().equals(saveVO.getBoModelType())) {
            Assert.isTrue((primaryCodes.isEmpty() || primaryCodes.contains(saveVO.getBoModelCode()) ? 1 : 0) != 0, (String)"\u4e3b\u8868\u53ea\u80fd\u6709\u4e00\u4e2a", (Object[])new Object[0]);
        }
        if ((boModelRelationDO = this.modelRelationRepoProc.getBoModelRelation(configuratorCode, saveVO.getBoModelCode())) == null) {
            boModelRelationDO = new DynamicConfiguratorBoModelRelationDO();
            boModelRelationDO.setDynamicConfiguratorCode(configuratorCode);
        }
        boModelRelationDO.setBoModelCode(saveVO.getBoModelCode());
        boModelRelationDO.setBoModelType(saveVO.getBoModelType());
        this.modelRelationRepoProc.save((Serializable)((Object)boModelRelationDO));
        return boModelRelationDO.getId();
    }

    private void publishMenu(DynamicConfiguratorPublishSaveVO saveVO) {
        ApiResult saveResult;
        SysMenuSaveDTO saveDTO = new SysMenuSaveDTO();
        saveDTO.setMenusAppCode(saveVO.getAppCode());
        saveDTO.setMenusName(saveVO.getMenuName());
        saveDTO.setMenusTypeEnum(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS);
        saveDTO.setMenusCode(saveVO.getMenuCode());
        saveDTO.setMenusParentCode(saveVO.getMenuGroupCode());
        saveDTO.setNodeTypeEnum(PlatformMenusNodeEnum.MENUS);
        saveDTO.setMenusRoute(saveVO.getMenuRoute());
        saveDTO.setMenusIcon(null);
        saveDTO.setOuterLink((Boolean)ObjUtil.defaultIfNull((Object)saveVO.getOuterLink(), (Object)false));
        if (saveDTO.getOuterLink().booleanValue()) {
            saveDTO.setOuterLinkTypeEnum((PlatformMenusOuterLinkTypeEnum)ObjUtil.defaultIfNull((Object)saveVO.getOuterLinkTypeEnum(), (Object)PlatformMenusOuterLinkTypeEnum.URL));
        }
        if (!(saveResult = this.menuRpcService.addMenu(saveDTO)).isSuccess()) {
            throw new BusinessException("\u4fdd\u5b58\u83dc\u5355\u5931\u8d25\uff0c" + saveResult.getMsg());
        }
    }

    private void revokeMenu(String menuCode) {
        this.menuRpcService.removeMenu(menuCode).computeData();
    }

    private boolean hasTableCreated(Long boModelId) {
        String created = this.boModelRepoProc.getCode(boModelId);
        return Boolean.TRUE.equals(created);
    }

    private boolean validateDbName(String str) {
        return str.length() <= 20 && PATTERN_DB_NAME.matcher(str).matches();
    }
}

