package com.elitescloud.cloudt.platform.model.constant;


import com.elitescloud.cloudt.system.vo.SysUdcVO;

/**
 * 管理员类型
 * **/
public enum PlatformAdminTypeEnum {
    SYS_ADMIN("SYS_PLATFORM", "PlatformAdminType", "管理员类型", "系统管理员",1),
    TENANT_ADMIN("SYS_PLATFORM", "PlatformAdminType", "管理员类型", "租户管理员",2),
    TENANT_ORG_ADMIN("SYS_PLATFORM", "PlatformAdminType", "管理员类型", "组织组织管理员",3)
    ;


    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    PlatformAdminTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }
}
