package com.elitescloud.cloudt.platform.model.constant;

import com.elitescloud.cloudt.system.vo.SysUdcVO;

public enum PlatformApiRequestTypeEnum {

    POST("SYS_PLATFORM", "ApiRequestType", "请求类型", "POST", 1),
    GET("SYS_PLATFORM", "ApiRequestType", "请求类型", "GET", 2),
    PUT("SYS_PLATFORM", "ApiRequestType", "请求类型", "PUT", 3),
    DELETE("SYS_PLATFORM", "ApiRequestType", "请求类型", "DELETE", 4),
    ;

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }

    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    PlatformApiRequestTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

}
