package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name = TableNameConstant.SYS_PLATFORM_API_PARAMETER)
@org.hibernate.annotations.Table(appliesTo = TableNameConstant.SYS_PLATFORM_API_PARAMETER, comment = "接口字段")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = TableNameConstant.SYS_PLATFORM_API_PARAMETER, description = "接口字段")
public class SysPlatformApiParameterDO extends BaseModel {
    public static final String TYPE_IN = "IN";
    public static final String TYPE_OUT = "OUT";

    @ApiModelProperty("字段所属接口id")
    @Comment("字段所属接口id")
    @Column
    Long apiId;

    @ApiModelProperty("字段所属接口编码")
    @Comment("字段所属接口编码")
    @Column
    String apiCode;

    @ApiModelProperty("字段名称")
    @Comment("字段名称")
    @Column
    String fieldName;

    @ApiModelProperty("字段类型 文本,数字,日期")
    @Comment("字段类型")
    @Column
    String fieldType;

    @ApiModelProperty("字段是否可以为空")
    @Comment("字段是否可以为空")
    @Column
    Boolean fieldIsNull;

    @ApiModelProperty("字段说明")
    @Comment("字段说明")
    @Column
    String fieldExplain;

    @ApiModelProperty("备注")
    @Comment("备注")
    @Column
    String remark;

    @ApiModelProperty("字段出入参数类型 入参,出参")
    @Comment("字段类型")
    @Column()
    String inOutType;
}
