package com.elitescloud.cloudt.platform.model.entity;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.Hibernate;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import java.io.Serializable;
import java.util.Objects;

/**
 * 平台应用管理
 */
@Entity

@org.hibernate.annotations.Table(appliesTo = TableNameConstant.SYS_PLATFORM_APP, comment = "平台应用管理")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = TableNameConstant.SYS_PLATFORM_APP, description = "平台应用管理")
@Table(name = TableNameConstant.SYS_PLATFORM_APP,uniqueConstraints = @UniqueConstraint(columnNames= {"appCode"}))
public class SysPlatformAppDO extends BaseModel implements Serializable
{

    @ApiModelProperty("应用编码")
    @Comment("应用编码")
    @Column
    String appCode;

    @ApiModelProperty("应用名称")
    @Comment("应用名称")
    @Column
    String appName;

    @ApiModelProperty("应用类型")
    @Comment("应用类型")
    @Column
    String appType;

    @ApiModelProperty("描述")
    @Comment("描述")
    @Column
    String appDescribe;

    @ApiModelProperty("状态")
    @Comment("状态")
    @Column()
    Boolean appState;

    @ApiModelProperty("排序")
    @Comment(value = "排序", defaultValue = "1")
    @Column()
    Integer appOrder;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) {
            return false;
        }
        SysPlatformAppDO that = (SysPlatformAppDO) o;
        return getId() != null && Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}
