package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 货币.
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/17
 */
@Entity
@Table(name = "sys_platform_currency", indexes = {
        @Index(name = "idx_currency_code", columnList = "currCode", unique = true),
})
@Comment("货币")
@Getter
@Setter
@DynamicInsert
public class SysPlatformCurrencyDO extends BaseModel {
    private static final long serialVersionUID = 2745709331833199972L;
    public static final String PATH_SEPARATOR = "|";

    @Column(nullable = false)
    @Comment(value = "货币编码")
    private String currCode;

    @Column(nullable = false)
    @Comment(value = "货币名称")
    private String currName;

    @Column()
    @Comment(value = "小数位数", defaultValue = "0")
    private Integer dispDecimal;

    @Column()
    @Comment(value = "是否启用，默认否", defaultValue = "0")
    private Boolean enabled;
}
