package com.elitescloud.cloudt.platform.model.params.api;

import com.elitescloud.cloudt.platform.model.constant.PlatformApiRequestTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
public class AddApiParam implements Serializable {

    @ApiModelProperty(value = "接口所属应用", position = 1, required = true)
    @NotBlank
    String appCode;

    @ApiModelProperty(value = "接口名称", position = 2, required = true)
    @NotBlank
    String apiName;

    @ApiModelProperty(value = "接口编号", position = 3, required = true)
    @NotBlank
    String apiCode;

    @ApiModelProperty(value = "请求类型", position = 4, required = true)
    @NotNull
    PlatformApiRequestTypeEnum requestType;

    @ApiModelProperty(value = "请求路径", position = 5, required = true)
    @NotBlank
    String apiPath;

    @ApiModelProperty(value = "接口描述", position = 6)
    String apiDescribe;

    @ApiModelProperty(value = "接口入参列表", position = 7)
    List<ApiFieldParam> inParams;

    @ApiModelProperty(value = "接口出参列表", position = 8)
    List<ApiFieldParam> outParams;

}
