package com.elitescloud.cloudt.platform.model.params.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.16
 **/
@Data
public class AddAppParam implements Serializable {

    @ApiModelProperty("应用编码")
    @NotBlank(message = "应用编码为空")
    private String appCode;

    @ApiModelProperty("应用名称")
    @NotBlank(message = "应用名称为空")
    private String appName;

    @ApiModelProperty("应用类型")
    @NotBlank(message = "应用类型为空")
    private String appType;

    @ApiModelProperty("启用状态")
    private Boolean appState;

    @ApiModelProperty("描述")
    private String appDescribe;

    @ApiModelProperty("排序")
    private Integer appOrder;
}
