package com.elitescloud.cloudt.platform.model.params.udc;

import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcValueVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.23
 **/
@Data
public class AddUdcValueParam implements Serializable {
    @ApiModelProperty("应用编码")
    @NotBlank
    String appCode;

    @ApiModelProperty("udc编码")
    @NotBlank
    String udcCode;

    @ApiModelProperty("值编码")
    @NotBlank
    String udcValueCode;

    @ApiModelProperty("值名称")
    @NotBlank
    String udcValueName;

    @ApiModelProperty("排序")
    Integer udcOrder;

    @ApiModelProperty("是否启用")
    Boolean allowStart;

    @ApiModelProperty("描述")
    String udcValueDescribe;

    @ApiModelProperty("是否内置")
    Boolean allowDefault;

    @ApiModelProperty("上级值编码")
    String parentUdcValueCode;
}
