package com.elitescloud.cloudt.platform.model.vo;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Data
@Accessors(chain = true)
@ApiModel(value = "sys_platform_udc", description = "平台应用udc")
public class SysPlatformUdcVO extends BaseModel implements Serializable {
    @ApiModelProperty("应用编码")
    String appCode;

    @ApiModelProperty("编码")
    String udcCode;

    @ApiModelProperty("名称")
    String udcName;

    @ApiModelProperty("允许编辑")
    Boolean allowUpdate;

    @ApiModelProperty("允许新增值")
    Boolean allowAddValue;

    @ApiModelProperty("上级UDC编码")
    private String parentUdcCode;

    @ApiModelProperty("描述")
    String udcDescribe;

    @ApiModelProperty("UDC值")
    List<SysPlatformUdcValueVO> sysPlatformUdcValueVOList;
}
