package com.elitescloud.cloudt.platform.model.vo.extend.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 新增区域保存信息.
 *
 * @author Kaiser（wang shao）
 * 2023/1/10
 */
@Data
@ApiModel(description = "新增区域保存信息")
public class PlatformAreaSaveVO implements Serializable {
    private static final long serialVersionUID = 7841890170404022062L;

    /**
     * ID，修改时不可为空
     */
    @ApiModelProperty(value = "ID，修改时不可为空", position = 1)
    private Long id;

    /**
     * 地区名称
     */
    @ApiModelProperty(value = "地区名称", position = 2, required = true)
    @NotBlank(message = "地区名称不能为空")
    private String areaName;

    /**
     * 地区编码
     */
    @ApiModelProperty(value = "地区编码", position = 3, required = true)
    @NotBlank(message = "地区编码不能为空")
    private String areaCode;

    /**
     * 简称
     */
    @ApiModelProperty(value = "简称", position = 4)
    private String shortName;

    /**
     * 上级编码
     */
    @ApiModelProperty(value = "上级编码", position = 5)
    private String parentAreaCode;

    /**
     * 类型，UDC[cloudt-system:areaType]
     */
    @ApiModelProperty(value = "类型，UDC[cloudt-system:areaType]", position = 6)
    private String areaType;

    /**
     * 邮编
     */
    @ApiModelProperty(value = "邮编", position = 7)
    private String zipCode;

    /**
     * 是否启用，默认是
     */
    @ApiModelProperty(value = "是否启用，默认是", position = 8)
    private Boolean enabled;

    /**
     * 顺序号，默认0
     */
    @ApiModelProperty(value = "顺序号，默认0", position = 9)
    private Integer sortNo;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 10)
    private String remark;
}
