package com.elitescloud.cloudt.platform.provider.callback;

import com.elitescloud.cloudt.platform.service.repo.*;
import com.elitescloud.cloudt.platform.service.repo.number.SysPlatformNextNumberRepoProc;
import com.elitescloud.cloudt.platform.service.repo.number.SysPlatformNumberRuleDtlRepoProc;
import com.elitescloud.cloudt.platform.service.repo.number.SysPlatformNumberRuleRepoProc;
import com.elitescloud.cloudt.system.service.callback.AppChangedCallback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/24
 */
@Component
public class AppDeletedCallback implements AppChangedCallback {
    @Autowired
    private SysPlatformMenusRepoProc menusRepoProc;
    @Autowired
    private SysPlatformAdminMenusRepoProc adminMenusRepoProc;
    @Autowired
    private SysPlatformApiManageRepoProc apiManageRepoProc;
    @Autowired
    private SysPlatformApiPermissionRepoProc apiPermissionRepoProc;
    @Autowired
    private SysPlatformMenusApiRepoProc menusApiRepoProc;
    @Autowired
    private SysPlatformNextNumberRepoProc nextNumberRepoProc;
    @Autowired
    private SysPlatformNumberRuleRepoProc numberRuleRepoProc;
    @Autowired
    private SysPlatformNumberRuleDtlRepoProc numberRuleDtlRepoProc;
    @Autowired
    private SysPlatformUdcRepoProc udcRepoProc;
    @Autowired
    private SysPlatformUdcValueRepoProc udcValueRepoProc;
    @Autowired
    private SysPlatformTmplRepoProc tmplRepoProc;

    @Override
    public void onDelete(String appCode, boolean real) {
        if (real) {
            // 删除菜单
            menusRepoProc.deleteByApp(appCode);
            adminMenusRepoProc.deleteForNotExists();
            // 删除接口
            apiManageRepoProc.deleteByApp(appCode);
            apiPermissionRepoProc.deleteByApp(appCode);
            menusApiRepoProc.deleteByApp(appCode);
            // 发号器
            numberRuleRepoProc.deleteByApp(appCode);
            numberRuleDtlRepoProc.deleteByApp(appCode);
            nextNumberRepoProc.deleteByApp(appCode);
            // UDC
            udcRepoProc.deleteByApp(appCode);
            udcValueRepoProc.deleteByApp(appCode);
            // 导入导出模板
            tmplRepoProc.deleteByApp(appCode);
        }
    }
}
