package com.elitescloud.cloudt.platform.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleDtlDTO;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleDtlVO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/6/18
 */
public interface ISysPlatformNumberRuleDtlService {

    /**
     * 批量更新规则明细
     *
     * @param details 规则明细列表
     */
    ApiResult<Long> updateInBatch(List<SysPlatformNumberRuleDtlVO> details);

    /**
     * 根据规则明细ID删除对应规则
     *
     * @param ids 规则明细ID
     */
    ApiResult<Boolean> removeByIds(List<Long> ids);

    /**
     * 根据规则ID删除对应所有的规则明细
     *
     * @param ruleId 规则ID
     */
    ApiResult<Long> removeByRuleId(Long ruleId);

    /**
     * 根据规则ID列出明细，按seq排序
     *
     * @param ruleId 规则ID
     * @return 规则明细列表
     */
    ApiResult<List<SysPlatformNumberRuleDtlVO>> listByRuleId(Long ruleId);

    /**
     * 根据规则ID获取规则信息
     *
     * @param ruleId 规则ID
     * @return 规则信息
     */
    ApiResult<List<SysPlatformNumberRuleDtlDTO>> listDtoByRuleId(Long ruleId);

    /**
     * 根据规则明细ID获取规则明细对象
     * @param id 规则明细ID
     * @return 规则明细对象
     */
    ApiResult<SysPlatformNumberRuleDtlVO> oneById(Long id);
}
