package com.elitescloud.cloudt.platform.service;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.params.app.AddAppParam;
import com.elitescloud.cloudt.platform.model.params.app.QueryAppParam;
import com.elitescloud.cloudt.platform.model.params.app.UpdateAppParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformAppVO;
import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.List;

/**
 * 平台应用管理
 */
public interface SysPlatformAppService {
    ApiResult<Long> addApp(AddAppParam addAppParam);

    ApiResult<Boolean> deleteFlagApp(Long id);
    ApiResult<Boolean> deleteApp(Long id);
    ApiResult<Boolean> updateApp(Long id, UpdateAppParam updateAppParam);

    ApiResult<Boolean> updateAppState(Long id, Boolean state);

    ApiResult<SysPlatformAppVO> getApp(Long id);

    ApiResult<PagingVO<SysPlatformAppVO>> pageMng(QueryAppParam queryAppParam);

    ApiResult<List<SysUdcVO>> getAppType();

    /**
     * 获取所有启用的app
     *
     * @return app列表
     */
    ApiResult<List<CodeNameParam>> all();

    /**
     * 分页查询app
     *
     * @param queryAppParam 查询参数
     * @return app
     */
    ApiResult<PagingVO<SysPlatformAppVO>> queryByPage(QueryAppParam queryAppParam);
}
