package com.elitescloud.cloudt.platform.service;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.params.udc.*;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcVO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @Description: 平台应用udc
 * @author: niu.chen
 * @date: 2022.09.15
 **/
public interface SysPlatformUdcService {
    ApiResult<Long> addUdc(AddUdcParam addUdcParam);

    ApiResult<Long> addUdcValue(AddUdcValueParam addUdcValueParam);

    /**
     * UDC值编辑
     *
     * @param saveVO UDC值信息
     * @return 值ID
     */
    ApiResult<Long> updateUdcValue(UdcValueSaveVO saveVO);

    ApiResult<Boolean> deleteFlagUdc(Long id);

    ApiResult<Boolean> deleteFlagUdcValue(Long id);

    ApiResult<Boolean> deleteUdc(Long id);

    ApiResult<Boolean> deleteUdcValue(Long id);

    ApiResult<Boolean> updateUdc(Long id, UpdateUdcParam updateUdcParam);

    ApiResult<Boolean> updateUdcValueAllowStart(Long id, Boolean allowStart);

    ApiResult<SysPlatformUdcVO> getUdc(Long id);

    ApiResult<PagingVO<SysPlatformUdcVO>> queryUdc(QueryUdcParam queryUdcParam);

    /**
     * 根据UDC编码获取UDC值列表
     *
     * @param appCode 应用编码
     * @param udcCode UDC编码
     * @return 值列表
     */
    ApiResult<List<CodeNameParam>> getValueList(@NotBlank String appCode, @NotBlank String udcCode);
}

