package com.elitescloud.cloudt.platform.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.convert.AppConvert;
import com.elitescloud.cloudt.platform.convert.MenusConvert;
import com.elitescloud.cloudt.platform.model.constant.PlatformAdminTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformAdminMenusDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.params.admin.AddAdminMenusParam;
import com.elitescloud.cloudt.platform.model.vo.GetAdminMenusVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformAppVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAdminMenusService;
import com.elitescloud.cloudt.platform.service.SysPlatformMenusService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAdminMenusRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAppRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: 管理员菜单
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Service
@Slf4j
@RequiredArgsConstructor
public class SysPlatformAdminMenusServiceImpl implements SysPlatformAdminMenusService {
    private final SysPlatformMenusService sysPlatformMenusService;

    private final SysPlatformAdminMenusRepo sysPlatformAdminMenusRepo;
    private final SysPlatformMenusRepo sysPlatformMenusRepo;
    private final SysPlatformAppRepo sysPlatformAppRepo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Boolean> addAdminMenus(AddAdminMenusParam addAdminMenusParam) {
        if (addAdminMenusParam.getMenusCodeList() != null && addAdminMenusParam.getMenusCodeList().size() > 0) {
            addAdminMenusParam.getMenusCodeList().forEach(code -> {
                SysPlatformMenusDO sysPlatformMenusDO = sysPlatformMenusRepo.findByMenusCode(code);
                Assert.notNull(sysPlatformMenusDO, "菜单编码不存在:" + code);
                if (!sysPlatformMenusDO.getNodeType().equals(PlatformMenusNodeEnum.MENUS.name())) {
                    throw new BusinessException("非法编码,不是菜单类型:" + code);
                }
            });
        }
        var listDO = addAdminMenusParam.getMenusCodeList().stream().map(s -> {
            SysPlatformAdminMenusDO sysPlatformAdminMenusDO = new SysPlatformAdminMenusDO();
            sysPlatformAdminMenusDO.setMenusCode(s);
            sysPlatformAdminMenusDO.setAdminType(addAdminMenusParam.getAdminType().name());
            return sysPlatformAdminMenusDO;
        }).collect(Collectors.toList());
        sysPlatformAdminMenusRepo.deleteAllByAdminType(addAdminMenusParam.getAdminType().name());
        sysPlatformAdminMenusRepo.saveAll(listDO);
        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<GetAdminMenusVO> getAdminMenus(PlatformAdminTypeEnum adminType) {

        List<SysPlatformAppVO> sysPlatformAppVOS = new ArrayList<>();
        List<SysPlatformMenusVO> sysPlatformMenusVOS = new ArrayList<>();


        var adminMenusDO = sysPlatformAdminMenusRepo.findAllByAdminType(adminType.name());

        var menusCodeList = adminMenusDO.stream().map(SysPlatformAdminMenusDO::getMenusCode).collect(Collectors.toList());
        var menusDOList = sysPlatformMenusRepo.findAllByMenusCodeIn(menusCodeList);
        sysPlatformMenusVOS = menusDOList.stream().map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO)
                //菜单状态是启用的
                .filter(SysPlatformMenusVO::getMenusState)
                .collect(Collectors.toList());

        List<String> appCodeList = menusDOList.stream().map(SysPlatformMenusDO::getMenusAppCode)
                .collect(Collectors.toList());

        if (!appCodeList.isEmpty()) {
            sysPlatformAppVOS = sysPlatformAppRepo.findByAppCodeIn(appCodeList)
                    .stream()
                    .filter(t -> Boolean.TRUE.equals(t.getAppState()))
                    .map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO)
                    .collect(Collectors.toList());
        }

        GetAdminMenusVO getAdminMenusVO = new GetAdminMenusVO();
        getAdminMenusVO.setAdminType(adminType.name());
        getAdminMenusVO.setAdminTypeName(adminType.getDescription());
        getAdminMenusVO.setSysPlatformAppVOS(sysPlatformAppVOS);
        getAdminMenusVO.setSysPlatformMenusVOS(sysPlatformMenusVOS);
        return ApiResult.ok(getAdminMenusVO);
    }


}
