package com.elitescloud.cloudt.platform.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.convert.AppConvert;
import com.elitescloud.cloudt.platform.convert.MenusConvert;
import com.elitescloud.cloudt.platform.convert.SysPlatformApiMangeConvert;
import com.elitescloud.cloudt.platform.convert.SysPlatformMenusApiConvert;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformMenusOuterLinkTypeEnum;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusApiDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.params.menus.*;
import com.elitescloud.cloudt.platform.model.vo.GetAppMenusVO;
import com.elitescloud.cloudt.platform.model.vo.MenusApiVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusApiVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusVO;
import com.elitescloud.cloudt.platform.service.SysPlatformMenusService;
import com.elitescloud.cloudt.platform.service.repo.*;
import com.elitescloud.cloudt.system.service.util.JpaPredicateBuilder;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import com.querydsl.core.types.Predicate;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Service
@Slf4j
@RequiredArgsConstructor
public class SysPlatformMenusServiceImpl implements SysPlatformMenusService {
    private final SysPlatformMenusRepo sysPlatformMenusRepo;
    private final SysPlatformMenusRepoProc sysPlatformMenusRepoProc;
    private final SysPlatformAppRepo sysPlatformAppRepo;
    private final SysPlatformMenusApiRepo sysPlatformMenusApiRepo;
    private final SysPlatformMenusApiRepoProc menusApiRepoProc;
    private final SysPlatformApiManageRepo sysPlatformApiManageRepo;
    private final SysPlatformAdminMenusRepoProc adminMenusRepoProc;
    private final TenantDataIsolateProvider tenantDataIsolateProvider;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> addMenusGroup(AddMenusParam param) {

        var saveDo = MenusConvert.INSTANCE.saveParamToDo(param);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.MENUS_GROUP.name());
        return saveDo(saveDo);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> addMenus(AddMenusParam param) {
        var saveDo = MenusConvert.INSTANCE.saveParamToDo(param);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.MENUS.name());
        return saveDo(saveDo);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> addButton(AddButtonParam param) {
        var saveDo = MenusConvert.INSTANCE.saveParamToDo(param);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.BUTTON.name());
        //  saveDo.setMenusType(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name());
        return saveDo(saveDo);
    }

    private ApiResult<Long> saveDo(SysPlatformMenusDO saveDo) {
        var list = sysPlatformMenusRepo.findAllByMenusCode(saveDo.getMenusCode());
        if (!list.isEmpty()) {
            var obj = list.get(0);
            return ApiResult.fail("菜单编码重复-（应用：" + obj.getMenusAppCode() + "-菜单名称：" + obj.getMenusName() + ")");
        }

        if (StringUtils.hasText(saveDo.getMenusParentCode())) {
            // 类型取上级菜单的类型，解决按钮时没有传递类型
            var parentMenu = sysPlatformMenusRepoProc.getByMenusCode(saveDo.getMenusParentCode());
            Assert.notNull(parentMenu, "上级菜单不存在");
            saveDo.setMenusType(parentMenu.getMenusType());
        }

        return ApiResult.ok(sysPlatformMenusRepo.save(saveDo).getId());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> addFormMenus(AddFormMenusParam addMenusParam) {
        var saveDo = MenusConvert.INSTANCE.saveParamToDo(addMenusParam);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.FORM_MENUS.name());
        //  saveDo.setMenusType(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name());
        return saveDo(saveDo);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> updateFormMenus(Long id, UpdateFormMenusParam updateMenusParam) {
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
//                    if (updateVerify(allowUpdate, sysPlatformAppDO, updateMenusParam.getMenusCode())) {
//                        return;
//                    }
//                    sysPlatformAppDO.setMenusAppCode(updateMenusParam.getMenusAppCode());
                    sysPlatformAppDO.setMenusName(updateMenusParam.getMenusName());
//                    sysPlatformAppDO.setMenusCode(updateMenusParam.getMenusCode());
                    sysPlatformAppDO.setMenusOrder(updateMenusParam.getMenusOrder());
                    sysPlatformAppDO.setMenusParentCode(updateMenusParam.getMenusParentCode());
                    sysPlatformAppDO.setMenusRoute(updateMenusParam.getMenusRoute());
                    sysPlatformAppDO.setMenusDescribe(updateMenusParam.getMenusDescribe());
                    sysPlatformAppDO.setMenusIcon(updateMenusParam.getMenusIcon());
                    sysPlatformAppDO.setDisplay(updateMenusParam.getDisplay());
                    sysPlatformMenusRepo.save(sysPlatformAppDO);
                },
                () -> {
                    throw new BusinessException("id不存在");
                });
        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<List<SysUdcVO>> getPlatformMenusOuterLinkTypeEnum() {
        return ApiResult.ok(
                List.of(
                        PlatformMenusOuterLinkTypeEnum.URL.getUdcVO(),
                        PlatformMenusOuterLinkTypeEnum.LCDP.getUdcVO(),
                        PlatformMenusOuterLinkTypeEnum.LCBP.getUdcVO()
                )

        );
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> updateMenusGroup(Long id, UpdateMenusParam updateMenusParam) {
        return updateMenus(id, updateMenusParam);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> updateMenus(Long id, UpdateMenusParam updateMenusParam) {
        //   AtomicReference<Boolean> allowUpdate = new AtomicReference<>(false);
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {

                    sysPlatformAppDO.setMenusName(updateMenusParam.getMenusName());
                    sysPlatformAppDO.setMenusType(updateMenusParam.getMenusType());
                    sysPlatformAppDO.setMenusOrder(updateMenusParam.getMenusOrder());
                    sysPlatformAppDO.setMenusParentCode(updateMenusParam.getMenusParentCode());
                    sysPlatformAppDO.setMenusRoute(updateMenusParam.getMenusRoute());
                    sysPlatformAppDO.setMenusDescribe(updateMenusParam.getMenusDescribe());
                    sysPlatformAppDO.setMenusIcon(updateMenusParam.getMenusIcon());
                    sysPlatformAppDO.setDisplay(updateMenusParam.getDisplay());
                    sysPlatformAppDO.setOuterLink(updateMenusParam.getOuterLink());
                    sysPlatformAppDO.setOuterLinkType(updateMenusParam.getOuterLinkType());
                    sysPlatformMenusRepo.save(sysPlatformAppDO);
                    //     allowUpdate.set(true);
                },
                () -> {
                    throw new BusinessException("id不存在");
                });
        return ApiResult.ok(true);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> updateButton(Long id, UpdateButtonParam updateMenusParam) {

        AtomicReference<Boolean> allowUpdate = new AtomicReference<>(false);
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
//                    if (updateVerify(allowUpdate, sysPlatformAppDO, updateMenusParam.getMenusCode())) {
//                        return;
//                    }
                    //  sysPlatformAppDO.setMenusAppCode(updateMenusParam.getMenusAppCode());
                    sysPlatformAppDO.setMenusName(updateMenusParam.getMenusName());
                    //   sysPlatformAppDO.setMenusCode(updateMenusParam.getMenusCode());
                    sysPlatformAppDO.setMenusOrder(updateMenusParam.getMenusOrder());
                    sysPlatformAppDO.setMenusParentCode(updateMenusParam.getMenusParentCode());
                    sysPlatformAppDO.setMenusDescribe(updateMenusParam.getMenusDescribe());
                    sysPlatformAppDO.setMenusIcon(updateMenusParam.getMenusIcon());
                    sysPlatformAppDO.setDisplay(updateMenusParam.getDisplay());
                    sysPlatformMenusRepo.save(sysPlatformAppDO);
                    allowUpdate.set(true);
                },
                () -> {
                    throw new BusinessException("id不存在");
                });
        if (allowUpdate.get()) {
            return ApiResult.ok(true);
        } else {
            return ApiResult.fail("菜单编码已经存在,重复:");
        }
    }

    private boolean updateVerify(AtomicReference<Boolean> allowUpdate,
                                 SysPlatformMenusDO sysPlatformAppDO, String menusCode) {
        //如果更新code 修改的code 不等于老code 需要进行唯一校验 如果是老code直接更新
        if (!sysPlatformAppDO.getMenusCode().equals(menusCode)) {
            var list =
                    sysPlatformMenusRepo.findAllByMenusCode(menusCode);
            if (!list.isEmpty()) {
                allowUpdate.set(false);
                return true;
                // throw new BusinessException("Code已经存在重复:" + updateMenusParam.getAppCode());
            }
        }
        return false;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> deleteFlagMenus(Long id) {
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformMenusDO ->
                {
                    sysPlatformMenusDO.setDeleteFlag(1);
                    sysPlatformMenusRepo.save(sysPlatformMenusDO);
                }
                ,
                () -> {
                    throw new BusinessException("id不存在");
                });

        return ApiResult.ok(true);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> updateMenusState(Long id, Boolean state) {
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformMenusDO ->
                {
                    sysPlatformMenusDO.setMenusState(state);
                    sysPlatformMenusRepo.save(sysPlatformMenusDO);
                }
                ,
                () -> {
                    throw new BusinessException("id不存在");
                });

        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<SysPlatformMenusVO> getMenus(Long id) {
        var objDO = sysPlatformMenusRepo.findById(id);
        if (objDO.isPresent()) {
            return ApiResult.ok(MenusConvert.INSTANCE.sysPlatformDOToSysPlatformVO(objDO.get()));
        } else {
            return ApiResult.fail("id不存在");
        }
    }

    @Override
    public ApiResult<List<SysPlatformMenusVO>> queryMenus(QueryMenusParam queryMenusParam) {
        List<SysPlatformMenusDO> listDO;
        var qdo = QSysPlatformMenusDO.sysPlatformMenusDO;
//        Predicate predicate = Expressions.booleanTemplate("1=1");
//        predicate = org.apache.commons.lang3.StringUtils.isBlank(queryMenusParam.getAppCode()) ? predicate :
//                ExpressionUtils.and(predicate, qdo.menusAppCode.eq(queryMenusParam.getAppCode()));
//        predicate = org.apache.commons.lang3.StringUtils.isBlank(queryMenusParam.getMenusName()) ? predicate :
//                ExpressionUtils.and(predicate, qdo.menusName.eq(queryMenusParam.getMenusName()));
//        predicate = org.apache.commons.lang3.StringUtils.isBlank(queryMenusParam.getMenusCode()) ? predicate :
//                ExpressionUtils.and(predicate, qdo.menusCode.eq(queryMenusParam.getMenusCode()));
//        predicate = queryMenusParam.getMenusType() == null ? predicate :
//                ExpressionUtils.and(predicate, qdo.menusType.eq(queryMenusParam.getMenusType().name()));
//        predicate = queryMenusParam.getMenusState() == null ? predicate :
//                ExpressionUtils.and(predicate, qdo.menusState.eq(queryMenusParam.getMenusState()));
//        predicate = org.apache.commons.lang3.StringUtils.isBlank(queryMenusParam.getNodeType()) ? predicate :
//                ExpressionUtils.and(predicate, qdo.nodeType.eq(queryMenusParam.getNodeType()));

        Predicate predicate = JpaPredicateBuilder.builder()
                .and(qdo.menusAppCode::eq,queryMenusParam.getAppCode())
                .and(qdo.menusName::eq,queryMenusParam.getMenusName())
                .and(qdo.menusCode::eq,queryMenusParam.getMenusCode())
                .and(qdo.menusType::eq,queryMenusParam.getMenusType().name())
                .and(qdo.menusState::eq,queryMenusParam.getMenusState())
                .and(qdo.nodeType::eq,queryMenusParam.getNodeType())
                .getPredicate();

        List<SysPlatformMenusVO> listVO = new ArrayList<>();

        sysPlatformMenusRepo.findAll(predicate)
                .iterator().forEachRemaining(sysPlatformMenusDO -> {
            listVO.add(MenusConvert.INSTANCE.sysPlatformDOToSysPlatformVO(sysPlatformMenusDO));
        });
        return ApiResult.ok(listVO);
    }

    @Override
    public ApiResult<List<SysUdcVO>> getMenusTypeEnum() {
//        List<SysUdcVO> sysUdcVOList = new ArrayList<>();
//        sysUdcVOList.add(PlatformConstantUtil.newSysUdcVO(PlatformEnum.PLATFORM_MENUS_TYPE_SYS));
//        sysUdcVOList.add(PlatformConstantUtil.newSysUdcVO(PlatformEnum.PLATFORM_MENUS_TYPE_BUS));
        return ApiResult.ok(
                List.of(
                        PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.getUdcVO(),
                        PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.getUdcVO()
                )

        );
    }

    @Override
    public ApiResult<GetAppMenusVO> getAllAppMenus() {
        GetAppMenusVO getAppMenusVO = new GetAppMenusVO();

        getAppMenusVO.setSysPlatformAppVOS(
                sysPlatformAppRepo.findAll()
                        .stream()
                        .filter(sysPlatformAppDO -> sysPlatformAppDO.getAppState() && sysPlatformAppDO.getDeleteFlag() == 0)
                        .map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO)
                        .collect(Collectors.toList()));

        getAppMenusVO.setSysPlatformMenusVOS(
                sysPlatformMenusRepo.findAll()
                        .stream()
                        .filter(sysPlatformMenusDO -> sysPlatformMenusDO.getMenusState() && sysPlatformMenusDO.getDeleteFlag() == 0)
                        .map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO)
                        .collect(Collectors.toList())
        );
        return ApiResult.ok(getAppMenusVO);
    }

    @Override
    public ApiResult<GetAppMenusVO> getSysAppMenusAll(PlatformAppMenusTypeEnum platformAppMenusTypeEnum) {
        String appType = null;
        String menusType = null;
        if (platformAppMenusTypeEnum.equals(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_SYS.name();
            menusType = PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name();
        } else if (platformAppMenusTypeEnum.equals(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_BUS.name();
            menusType = PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name();
        }

        GetAppMenusVO getAppMenusVO = new GetAppMenusVO();
        if (appType != null) {
            getAppMenusVO.setSysPlatformAppVOS(sysPlatformAppRepo.findByAppType(appType)
                    .stream()
                    .map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO)
                    .collect(Collectors.toList()));

        }
        if (menusType != null) {
            getAppMenusVO.setSysPlatformMenusVOS(
                    sysPlatformMenusRepo.findAllByMenusTypeAndDeleteFlag(
                                    menusType,
                                    0).stream()
                            .map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO)
                            .collect(Collectors.toList())
            );
        }
        return ApiResult.ok(getAppMenusVO);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> deleteMenus(Long id) {
        sysPlatformMenusRepo.findById(id).ifPresentOrElse(menusDO -> {
            Integer count = sysPlatformMenusRepo.findAllByMenusParentCode(menusDO.getMenusCode()).size();
            if (count != 0) {
                throw new BusinessException("请先删除子菜单。子菜单数量：" + count);
            } else {
                sysPlatformMenusRepo.deleteById(id);

                // 删除管理员菜单
                adminMenusRepoProc.deleteByMenuCode(menusDO.getMenusCode());
                // 删除菜单下的接口
                menusApiRepoProc.deleteByMenuCode(menusDO.getMenusCode());
            }

        }, () -> {
            throw new BusinessException("id不存在");
        });

        return ApiResult.ok();
    }


    @Override
    public ApiResult<GetAppMenusVO> getSysBusAppMenus(PlatformAppMenusTypeEnum platformAppMenusTypeEnum) {
        String appType = null;
        String menusType = null;
        if (platformAppMenusTypeEnum.equals(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_SYS.name();
            menusType = PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name();
        } else if (platformAppMenusTypeEnum.equals(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_BUS.name();
            menusType = PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name();
        }

        GetAppMenusVO getAppMenusVO = new GetAppMenusVO();
        if (appType != null) {
            getAppMenusVO.setSysPlatformAppVOS(sysPlatformAppRepo.findByAppTypeAndAppState(appType, true)
                    .stream()
                    .map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO)
                    .collect(Collectors.toList()));

        }
        if (menusType != null) {
            getAppMenusVO.setSysPlatformMenusVOS(
                    sysPlatformMenusRepo.findAllByMenusTypeAndMenusStateAndDeleteFlag(
                                    menusType,
                                    // PlatformMenusNodeEnum.MENUS.name(),
                                    true,
                                    0).stream()
                            .map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO)
                            .collect(Collectors.toList())
            );
        }
        return ApiResult.ok(getAppMenusVO);
    }

    @Override
    public ApiResult<List<SysPlatformMenusApiVO>> getAllAppMenusApi(String appCode) {

//        var listVo = sysPlatformMenusRepo.findAllByMenusAppCode(appCode)
//                .stream()
//                .filter(sysPlatformMenusDO ->  sysPlatformMenusDO.getDeleteFlag() == 0)
//                .map(SysPlatformMenusApiConvert.INSTANCE::sysPlatformDOToSysPlatformMenusApiVO)
//                .collect(Collectors.toList());
//        for (SysPlatformMenusApiVO menusVO : listVo) {
//            var count = sysPlatformMenusApiRepo.countAllByMenusId(menusVO.getId());
//            menusVO.setApiNum(count);
//        }
        return ApiResult.ok(sysPlatformMenusRepoProc.getMenusSumApi(appCode));
    }

    @Override
    public ApiResult<Boolean> addMenusApi(AddMenusApiParam addMenusApiParam) {
        var menusApis = sysPlatformMenusApiRepo.findAllByAppIdAndMenusId(addMenusApiParam.getAppId(), addMenusApiParam.getMenusId());
        menusApis.forEach(sysPlatformMenusApiDO -> {
            if (Objects.equals(sysPlatformMenusApiDO.getApiId(), addMenusApiParam.getApiId())) {
                throw new BusinessException("接口已挂载");
            }
        });
        var saveDo = SysPlatformMenusApiConvert.INSTANCE.saveParamToDo(addMenusApiParam);
        sysPlatformMenusApiRepo.save(saveDo);
        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<Boolean> deleteMenusApi(DeleteMenusApiParam deleteMenusApiParam) {
        var sysPlatformMenusApiDO = sysPlatformMenusApiRepo.findByAppIdAndMenusIdAndApiId(deleteMenusApiParam.getAppId(), deleteMenusApiParam.getMenusId(), deleteMenusApiParam.getApiId());
        Assert.notNull(sysPlatformMenusApiDO, "数据不存在");
        sysPlatformMenusApiRepo.delete(sysPlatformMenusApiDO);
        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<List<MenusApiVO>> getMenusApis(Long appId, Long menusId) {
        var voList = new ArrayList<MenusApiVO>();
        var menusApiDo = sysPlatformMenusApiRepo.findAllByAppIdAndMenusId(appId, menusId);
        for (SysPlatformMenusApiDO menusApi : menusApiDo) {
            var sysPlatformApiManageDO = sysPlatformApiManageRepo.findById(menusApi.getApiId());
            if (sysPlatformApiManageDO.isPresent()) {
                var menusApiVO = SysPlatformApiMangeConvert.INSTANCE.doToVo(sysPlatformApiManageDO.get());
                voList.add(menusApiVO);
            } else {
                throw new BusinessException("apiId: " + menusApi.getApiId() + "不存在");
            }
        }
        return ApiResult.ok(voList);
    }
}
