package com.elitescloud.cloudt.platform.service.repo;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformApiPermissionDO;
import com.elitescloud.cloudt.platform.model.params.api.AddApiPermissionParam;
import com.elitescloud.cloudt.platform.model.params.api.GetApiPermissionParam;
import com.elitescloud.cloudt.platform.model.vo.GetAppMenusVO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Description: api权限配置
 * @author: niu.chen
 * @date: 2022.09.15
 **/

@Repository
public interface SysPlatformApiPermissionRepo extends JpaRepository<SysPlatformApiPermissionDO, Long>,
        QuerydslPredicateExecutor<SysPlatformApiPermissionDO> {

        List<SysPlatformApiPermissionDO> findAllByMenusCode(String menus);
}
