package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformApiPermissionDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformApiPermissionDO;
import com.querydsl.core.types.dsl.EntityPathBase;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Description: api权限配置
 * @author: niu.chen
 * @date: 2022.09.15
 **/

@Repository
public class SysPlatformApiPermissionRepoProc extends BaseRepoProc<SysPlatformApiPermissionDO> {
    private static final QSysPlatformApiPermissionDO QDO = QSysPlatformApiPermissionDO.sysPlatformApiPermissionDO;

    public SysPlatformApiPermissionRepoProc() {
        super(QDO);
    }

    /**
     * 根据应用编码删除
     *
     * @param appCode 应用编码
     */
    public void deleteByApp(@NotBlank String appCode) {
        super.deleteByValue(QDO.appCode, appCode);
    }
}
