package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusApiDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface SysPlatformMenusApiRepo extends JpaRepository<SysPlatformMenusApiDO, Long>,
        QuerydslPredicateExecutor<SysPlatformMenusApiDO> {

    List<SysPlatformMenusApiDO> findAllByAppIdAndMenusId(Long appId, Long menusId);

    SysPlatformMenusApiDO findByAppIdAndMenusIdAndApiId(Long appId, Long menusId, Long apiId);

    Integer countAllByMenusId(Long menusId);

    void deleteAllByApiId(Long apiId);
}
