package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.boot.model.entity.BaseTreeModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 行政区域.
 *
 * @author Kaiser（wang shao）
 * 2023/1/17
 */
@Entity
@Table(name = "sys_platform_area", indexes = {
        @Index(name = "idx_area_code", columnList = "areaCode"),
        @Index(name = "idx_area_parent_code", columnList = "parentAreaCode"),
        @Index(name = "idx_area_pid", columnList = "pId"),
        @Index(name = "idx_area_rootid", columnList = "rootId"),
        @Index(name = "idx_area_lft", columnList = "lft"),
        @Index(name = "idx_area_rgt", columnList = "rgt"),
})
@Comment("行政区域")
@Getter
@Setter
public class SysPlatformAreaDO extends BaseTreeModel {
    private static final long serialVersionUID = 2745709331833199972L;
    public static final String PATH_SEPARATOR = "|";

    @Column(nullable = false)
    @Comment(value = "地区名称")
    private String areaName;

    @Column(nullable = false)
    @Comment(value = "地区编码")
    private String areaCode;

    @Column()
    @Comment(value = "上级地区编码")
    private String parentAreaCode;

    @Column()
    @Comment(value = "简称")
    private String shortName;

    /**
     * {@link com.elitescloud.cloudt.constant.AreaType}
     */
    @Column()
    @Comment(value = "类型，UDC[cloudt-system:areaType]")
    private String areaType;

    @Column()
    @Comment(value = "邮编")
    private String zipCode;

    @Column()
    @Comment(value = "是否启用，默认是", defaultValue = "1")
    private Boolean enabled;

    @Column()
    @Comment(value = "编码路径")
    private String codePath;

    @Column()
    @Comment(value = "汉语拼音")
    private String pinyin;
}
