package com.elitescloud.cloudt.platform.model.entity;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * <pre>发号器规则定义</pre>
 *
 * @author Michael Li
 * 2020-10-10
 */

@Entity
@Table(name = "sys_platform_number_rule")
@org.hibernate.annotations.Table(appliesTo = "sys_platform_number_rule", comment = "发号器规则")
@Data
@Accessors(chain = true)
@ApiModel(value = "发号器规则", description = "发号器规则")
public class SysPlatformNumberRuleDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -2550818946023069619L;

    @Comment("应用编号")
    @Column(nullable = false)
    private String appCode;

    @Comment("规则编号")
    @Column(nullable = false)
    private String ruleCode;

    @Comment("规则名称")
    @Column()
    private String ruleName;

    @Comment("取号示例")
    @Column()
    private String sampleCode;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    private Boolean enabled;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysPlatformNumberRuleDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysPlatformNumberRuleDO entity = (SysPlatformNumberRuleDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}

