package com.elitescloud.cloudt.platform.model.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Data
@Accessors(chain = true)
@ApiModel(value = "sys_platform_udc_value", description = "udc值")
public class SysPlatformUdcValueVO extends BaseModel implements Serializable {
    @ApiModelProperty("应用编码")
    String appCode;

    @ApiModelProperty("udc编码")
    String udcCode;

    @ApiModelProperty("值编码")
    String udcValueCode;

    @ApiModelProperty("值名称")
    String udcValueName;

    @ApiModelProperty("排序")
    Integer udcOrder;

    @ApiModelProperty("是否启用")

    Boolean allowStart;

    @ApiModelProperty("描述")
    String udcValueDescribe;

    @ApiModelProperty("是否内置")
    Boolean allowDefault;

    @ApiModelProperty("上级UDC值编码")
    private String parentUdcValueCode;
}
