package com.elitescloud.cloudt.platform.model.vo.resp;

import com.elitescloud.cloudt.system.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.system.constant.PlatformMenusNodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 菜单基本信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/22
 */
@Getter
@Setter
@ApiModel(description = "菜单基本信息")
public class MenuBasicRespVO implements Serializable {
    private static final long serialVersionUID = -1770658402608682688L;

    @ApiModelProperty(value = "菜单ID")
    private Long id;

    @ApiModelProperty(value = "应用编码")
    private String menusAppCode;

    @ApiModelProperty(value = "应用名称")
    private String menusAppName;

    @ApiModelProperty(value = "菜单名称")
    private String menusName;

    /**
     * 取值：{@link PlatformAppMenusTypeEnum}
     */
    @ApiModelProperty(value = "菜单类型")
    private String menusType;
    private String menusTypeName;

    /**
     * 取值：{@link PlatformMenusNodeEnum}
     */
    @ApiModelProperty(value = "节点类型")
    private String nodeType;
    private String nodeTypeName;

    @ApiModelProperty(value = "菜单编码")
    private String menusCode;

    @ApiModelProperty(value = "菜单路由")
    private String menusRoute;

    @ApiModelProperty(value = "描述")
    private String menusDescribe;
}
