package com.elitescloud.cloudt.platform.service.repo;


import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.constant.PlatformAdminTypeEnum;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformAdminMenusDO;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformAdminMenusDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusDO;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @Description: 管理员菜单
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Repository
public class SysPlatformAdminMenusRepoProc extends BaseRepoProc<SysPlatformAdminMenusDO> {
    private static final QSysPlatformAdminMenusDO QDO = QSysPlatformAdminMenusDO.sysPlatformAdminMenusDO;
    private static final QSysPlatformMenusDO QDO_MENU = QSysPlatformMenusDO.sysPlatformMenusDO;

    public SysPlatformAdminMenusRepoProc() {
        super(QDO);
    }

    public void deleteByAdminType(@NotBlank String adminType) {
        super.deleteByValue(QDO.adminType, adminType);
    }

    /**
     * 根据菜单删除
     *
     * @param menuCode 菜单编码
     */
    public void deleteByMenuCode(@NotBlank String menuCode) {
        super.deleteByValue(QDO.menusCode, menuCode);
    }

    /**
     * 删除菜单已不存在的
     */
    public void deleteForNotExists() {
        super.jpaQueryFactory.delete(QDO)
                .where(JPAExpressions.select(QDO_MENU.id)
                        .from(QDO_MENU)
                        .where(QDO.menusCode.eq(QDO_MENU.menusCode))
                        .notExists());
    }

    public List<SysPlatformMenusDO> queryMenusByAdminType(PlatformAdminTypeEnum adminType) {
        var predicate = PredicateBuilder.builder()
                .andIn(adminType != null, QDO_MENU.menusCode, () -> JPAExpressions.select(QDO.menusCode).from(QDO).where(QDO.adminType.eq(adminType.name())))
                .build();
        return super.jpaQueryFactory.selectFrom(QDO_MENU)
                .where(predicate)
                .fetch();
    }
}
