package com.elitescloud.cloudt.platform.model.vo.extend.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 货币保存.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
@Data
@ApiModel(description = "货币保存")
public class CurrencySaveVO implements Serializable {
    private static final long serialVersionUID = 8768904065837018667L;

    /**
     * 记录ID，编辑时不可为空
     */
    @ApiModelProperty(value = "记录ID，编辑时不可为空", position = 1)
    private Long id;

    /**
     * 货币编码
     */
    @ApiModelProperty(value = "货币编码", position = 2, required = true)
    @NotBlank(message = "货币编码为空")
    private String currCode;

    /**
     * 货币名称
     */
    @ApiModelProperty(value = "货币名称", position = 3, required = true)
    @NotBlank(message = "货币名称为空")
    private String currName;

    /**
     * 小数位数
     */
    @ApiModelProperty(value = "小数位数", position = 4)
    private Integer dispDecimal;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 5)
    private Boolean enabled;
}
