/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.convert.AppConvert;
import com.elitescloud.cloudt.platform.model.params.app.AddAppParam;
import com.elitescloud.cloudt.platform.model.params.app.QueryAppParam;
import com.elitescloud.cloudt.platform.model.params.app.UpdateAppParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformAppVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAppService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAppRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAppRepoProc;
import com.elitescloud.cloudt.system.cacheable.SysCacheAppRpcService;
import com.elitescloud.cloudt.system.constant.SysTerminalType;
import com.elitescloud.cloudt.system.service.callback.AppChangedCallback;
import com.elitescloud.cloudt.system.service.common.constant.AppAuthTypeEnum;
import com.elitescloud.cloudt.system.service.common.constant.PlatformAppTypeEnum;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAppDO;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysPlatformAppServiceImpl
implements SysPlatformAppService {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformAppServiceImpl.class);
    private final SysPlatformAppRepo sysPlatformAppRepo;
    private final SysPlatformAppRepoProc sysPlatformAppRepoProc;
    private final RedisUtils redisUtils;
    private final ObjectProvider<AppChangedCallback> appChangedCallbacks;
    @Autowired
    private SysCacheAppRpcService cacheAppRpcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addApp(AddAppParam addAppParam) {
        List<SysPlatformAppDO> list = this.sysPlatformAppRepo.findByAppCode(addAppParam.getAppCode());
        if (!list.isEmpty()) {
            return ApiResult.fail((String)"AppCode\u91cd\u590d");
        }
        addAppParam.setAppState((Boolean)ObjectUtil.defaultIfNull((Object)addAppParam.getAppState(), (Object)true));
        addAppParam.setAppOrder((Integer)ObjectUtil.defaultIfNull((Object)addAppParam.getAppOrder(), (Object)0));
        addAppParam.setOuterApp((Boolean)ObjectUtil.defaultIfNull((Object)addAppParam.getOuterApp(), (Object)false));
        addAppParam.setAuthType((String)ObjectUtil.defaultIfBlank((CharSequence)addAppParam.getAuthType(), (CharSequence)AppAuthTypeEnum.AUTHED.name()));
        addAppParam.setAdaptedTerminal((String)ObjectUtil.defaultIfBlank((CharSequence)addAppParam.getAdaptedTerminal(), (CharSequence)SysTerminalType.WEB.getValue()));
        SysPlatformAppDO saveDo = AppConvert.INSTANCE.saveParamToDo(addAppParam);
        Long id = ((SysPlatformAppDO)this.sysPlatformAppRepo.save(saveDo)).getId();
        this.clearCache();
        for (AppChangedCallback callback : this.appChangedCallbacks) {
            callback.onSave(true, saveDo.getAppCode());
        }
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteFlagApp(Long id) {
        this.sysPlatformAppRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
            sysPlatformAppDO.setDeleteFlag(Integer.valueOf(1));
            this.sysPlatformAppRepo.save(sysPlatformAppDO);
            this.clearCache();
            for (AppChangedCallback callback : this.appChangedCallbacks) {
                callback.onDelete(sysPlatformAppDO.getAppCode(), false);
            }
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteApp(Long id) {
        Optional appDo = this.sysPlatformAppRepo.findById(id);
        if (appDo.isPresent()) {
            log.info("App\u5e94\u7528\u5220\u9664\uff1a{}", appDo.get());
            this.sysPlatformAppRepo.deleteById(id);
            this.clearCache();
            for (AppChangedCallback callback : this.appChangedCallbacks) {
                callback.onDelete(((SysPlatformAppDO)appDo.get()).getAppCode(), true);
            }
        } else {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateApp(Long id, UpdateAppParam updateAppParam) {
        updateAppParam.setAppOrder((Integer)ObjectUtil.defaultIfNull((Object)updateAppParam.getAppOrder(), (Object)0));
        updateAppParam.setOuterApp((Boolean)ObjectUtil.defaultIfNull((Object)updateAppParam.getOuterApp(), (Object)false));
        updateAppParam.setAuthType((String)ObjectUtil.defaultIfBlank((CharSequence)updateAppParam.getAuthType(), (CharSequence)AppAuthTypeEnum.AUTHED.name()));
        updateAppParam.setAdaptedTerminal((String)ObjectUtil.defaultIfBlank((CharSequence)updateAppParam.getAdaptedTerminal(), (CharSequence)SysTerminalType.WEB.getValue()));
        AtomicReference<Boolean> allowUpdate = new AtomicReference<Boolean>(false);
        this.sysPlatformAppRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
            sysPlatformAppDO.setAppName(updateAppParam.getAppName());
            sysPlatformAppDO.setAppType(updateAppParam.getAppType());
            sysPlatformAppDO.setAdaptedTerminal(updateAppParam.getAdaptedTerminal());
            sysPlatformAppDO.setAppDescribe(updateAppParam.getAppDescribe());
            sysPlatformAppDO.setAppOrder(updateAppParam.getAppOrder());
            sysPlatformAppDO.setOuterApp(updateAppParam.getOuterApp());
            sysPlatformAppDO.setAuthType(updateAppParam.getAuthType());
            sysPlatformAppDO.setUrl(updateAppParam.getUrl());
            sysPlatformAppDO.setTokenUrl(updateAppParam.getTokenUrl());
            sysPlatformAppDO.setIcon(updateAppParam.getIcon());
            this.sysPlatformAppRepo.save(sysPlatformAppDO);
            allowUpdate.set(true);
            this.clearCache();
            for (AppChangedCallback callback : this.appChangedCallbacks) {
                callback.onSave(false, sysPlatformAppDO.getAppCode());
            }
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        if (allowUpdate.get().booleanValue()) {
            return ApiResult.ok((Object)true);
        }
        return ApiResult.fail((String)"\u7f16\u7801\u5df2\u5b58\u5728");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateAppState(Long id, Boolean state) {
        this.sysPlatformAppRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
            sysPlatformAppDO.setAppState(state);
            this.sysPlatformAppRepo.save(sysPlatformAppDO);
            this.clearCache();
            for (AppChangedCallback callback : this.appChangedCallbacks) {
                callback.onEnabled(sysPlatformAppDO.getAppCode(), Boolean.TRUE.equals(state));
            }
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok();
    }

    @Override
    public ApiResult<SysPlatformAppVO> getApp(Long id) {
        Optional appDO = this.sysPlatformAppRepo.findById(id);
        if (appDO.isPresent()) {
            return ApiResult.ok((Object)AppConvert.INSTANCE.sysPlatformAppDOToSysPlatformAppVO((SysPlatformAppDO)appDO.get()));
        }
        return ApiResult.fail((String)"id\u4e0d\u5b58\u5728");
    }

    @Override
    public ApiResult<PagingVO<SysPlatformAppVO>> pageMng(QueryAppParam queryAppParam) {
        PagingVO pagingVo = this.sysPlatformAppRepoProc.pageMng(queryAppParam).map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO);
        return ApiResult.ok((Object)pagingVo);
    }

    @Override
    public ApiResult<List<SysUdcVO>> getAppType() {
        return ApiResult.ok(List.of(PlatformAppTypeEnum.APP_TYPE_SYS.getUdcVO(), PlatformAppTypeEnum.APP_TYPE_BUS.getUdcVO()));
    }

    @Override
    public ApiResult<List<CodeNameParam>> all() {
        List<CodeNameParam> result = this.sysPlatformAppRepoProc.allEnabled();
        try {
            this.redisUtils.set("cloudt_app_all", result.stream().map(t -> new CodeNameParam(t.getCode(), t.getName())).collect(Collectors.toList()));
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58APP\u5f02\u5e38", (Throwable)e);
        }
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<PagingVO<SysPlatformAppVO>> queryByPage(QueryAppParam queryAppParam) {
        PagingVO pagingVo = this.sysPlatformAppRepoProc.pageQuery(queryAppParam).map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO);
        return ApiResult.ok((Object)pagingVo);
    }

    @Override
    public ApiResult<List<SysPlatformAppVO>> listApp(Boolean outerApp, Boolean authed) {
        List voList = this.sysPlatformAppRepoProc.list(outerApp, authed).stream().map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO).collect(Collectors.toList());
        return ApiResult.ok(voList);
    }

    private void clearCache() {
        try {
            this.redisUtils.del(new String[]{"cloudt_app_all"});
        }
        catch (Exception e) {
            log.error("\u6e05\u7a7aapp\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
        }
        this.cacheAppRpcService.clearCache();
    }

    public SysPlatformAppServiceImpl(SysPlatformAppRepo sysPlatformAppRepo, SysPlatformAppRepoProc sysPlatformAppRepoProc, RedisUtils redisUtils, ObjectProvider<AppChangedCallback> appChangedCallbacks) {
        this.sysPlatformAppRepo = sysPlatformAppRepo;
        this.sysPlatformAppRepoProc = sysPlatformAppRepoProc;
        this.redisUtils = redisUtils;
        this.appChangedCallbacks = appChangedCallbacks;
    }
}

