package com.elitescloud.cloudt.platform.model.entity;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/9 10:53
 */

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.platform.model.constant.SqlTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 数据源表;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-10-9
 */
@Entity
@ApiModel(value = "sql执行存储", description = "")
@Table(name = "sys_platform_sql_execute")
@org.hibernate.annotations.Table(appliesTo = "sys_platform_sql_execute", comment = "sql执行存储")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
public class SysPlatformSqlExecuteDO extends BaseModel implements Serializable {

    /**
     * 数据源名称
     */
    @ApiModelProperty(name = "SQL命令命名，方便前端显示", notes = "")
    @Comment("SQL命令命名")
    @Column()
    private String sqlName;

    @Comment("SQL编码")
    @Column()
    private String sqlCode;

    /**
     * 分类
     * <p>
     * {@link com.elitescloud.cloudt.platform.model.constant.SqlExecuteCategory}
     */
    @Comment("分类, [udc]cloudt-system:sqlCategory")
    @Column()
    private String category;

    /**
     * SQL类型
     * <p>
     * {@link SqlTypeEnum}
     */
    @Comment("SQL类型")
    @Column()
    private String sqlType;

    @Comment("限制数据量")
    @Column()
    private Integer limitSize;

    /**
     * 驱动类
     */
    @ApiModelProperty(name = "存储SQL命令", notes = "")
    @Lob
    @Comment("存储SQL命令")
    @Column()
    private String querySql;
    /**
     * 连接地址
     */
    @ApiModelProperty(name = "数据源的标识或名称", notes = "")
    @Comment("数据源的标识或名称")
    @Column()
    private String datasourceName;

    @ApiModelProperty(name = "SQL执行结果", notes = "")
    @Lob
    @Comment("SQL执行结果")
    @Column()
    private String executeSqlResult;

    @ApiModelProperty(name = "SQL执行时间/毫秒", notes = "")
    @Comment("SQL执行时间/毫秒")
    @Column()
    private Long executeSqlDelay;

    @Comment("开始时间")
    private LocalDateTime executeStartTime;
    @Comment("结束时间")
    private LocalDateTime executeEndTime;


}
