package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import io.swagger.annotations.ApiModel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @deprecated 已弃用，新版本使用菜单和业务对象操作的绑定
 */
@Entity
@Table(name = TableNameConstant.SYS_PLATFORM_MENUS_API)
@org.hibernate.annotations.Table(appliesTo = TableNameConstant.SYS_PLATFORM_MENUS_API, comment = "菜单接口")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = TableNameConstant.SYS_PLATFORM_MENUS_API, description = "菜单接口")
@Deprecated(since = "3.3.0")
public class SysPlatformMenusApiDO extends BaseStdModel {
    private static final long serialVersionUID = 1780348361167473570L;

    @Comment("应用id")
    @Column(nullable = false)
    private Long appId;

    @Comment("应用编码")
    @Column(nullable = false)
    private String appCode;

    @Comment("菜单id")
    @Column(nullable = false)
    private Long menusId;

    @Comment("菜单编码")
    @Column(nullable = false)
    private String menusCode;

    @Comment("接口id")
    @Column(nullable = false)
    private Long apiId;

    @Comment("接口编码")
    @Column()
    private String apiCode;
}
