package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformCurrencyDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformCurrencyDO;
import com.elitescloud.cloudt.platform.model.vo.extend.query.CurrencyPageQueryVO;
import com.querydsl.core.types.Projections;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/29
 */
@Repository
public class SysPlatformCurrencyRepoProc extends BaseRepoProc<SysPlatformCurrencyDO> {
    private static final QSysPlatformCurrencyDO QDO = QSysPlatformCurrencyDO.sysPlatformCurrencyDO;

    public SysPlatformCurrencyRepoProc() {
        super(QDO);
    }

    /**
     * 更新启用状态
     *
     * @param id
     * @param enabled
     */
    public void updateEnabled(long id, Boolean enabled) {
        super.updateValue(QDO.enabled, enabled, id);
    }

    /**
     * 判断编码是否存在
     *
     * @param currCode
     * @param id
     * @return
     */
    public boolean existsCode(@NotBlank String currCode, Long id) {
        return super.exists(QDO.currCode, currCode, id);
    }

    /**
     * 获取启用状态
     *
     * @param id
     * @return
     */
    public Boolean getEnabled(long id) {
        return super.getValue(QDO.enabled, id);
    }

    /**
     * 获取货币编码
     *
     * @param id
     * @return
     */
    public String getCurrCode(long id) {
        return super.getValue(QDO.currCode, id);
    }

    /**
     * 分页查询管理
     *
     * @param queryVO
     * @return
     */
    public PagingVO<SysPlatformCurrencyDO> pageMng(CurrencyPageQueryVO queryVO) {
        var predicate = PredicateBuilder.builder()
                .andLike(StringUtils.hasText(queryVO.getCurrCode()), QDO.currCode, queryVO.getCurrCode())
                .andLike(StringUtils.hasText(queryVO.getCurrName()), QDO.currName, queryVO.getCurrName())
                .andEq(queryVO.getEnabled() != null, QDO.enabled, queryVO.getEnabled())
                .build();
        return super.queryByPage(predicate, queryVO.getPageRequest());
    }

    /**
     * 所有启用的
     *
     * @return
     */
    public List<CodeNameParam> listAll() {
        return super.jpaQueryFactory.select(Projections.bean(CodeNameParam.class, QDO.currCode.as("code"), QDO.currName.as("name")))
                .from(QDO)
                .where(QDO.enabled.eq(true))
                .fetch();
    }
}
