package com.elitescloud.cloudt.platform.service.number;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 根据每个编码规则ID，对应一个 NumberBuilder，
 * 成员按照编码规则明细的顺序组织
 * 未来提供每个编码算子并行构建，最后统一给出完整拼接的编号
 *
 * @author Michael Lee
 * @since 3.3.0
 */
@Data
@Accessors(chain = true)
public class NumberBuilder {
    private Long ruleId;

    private Long tenantId;

    private List<INumberOperator> operators;

    public String generateNumber() {
        return operators.stream().map(INumberOperator::getNumberString).collect(Collectors.joining());
    }
}
