package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformDatabaseSourceDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformDatabaseSourceDO;
import com.elitescloud.cloudt.system.datasource.SysPlatformDatabaseSourceQueryParam;
import com.querydsl.core.types.Predicate;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/25 13:51
 */
public interface SysPlatformDatabaseSourceRepo extends JpaRepository<SysPlatformDatabaseSourceDO, Long>,
        QuerydslPredicateExecutor<SysPlatformDatabaseSourceDO>{

    default Predicate getPredicate(SysPlatformDatabaseSourceQueryParam param) {
        var QDO= QSysPlatformDatabaseSourceDO.sysPlatformDatabaseSourceDO;
        var predicate = JpaPredicateBuilder.builder()
                .and(QDO.dbsDbName::eq, param.getDbsName())
                .and(QDO.dbsType::eq,param.getDbsType()==null?null: param.getDbsType().name())
                .and(QDO.dbsCode::eq, param.getDbsCode())
                .getPredicate();
        return predicate;
    }


    SysPlatformDatabaseSourceDO findByDbsCode(String dbsCode);
}
