package com.elitescloud.cloudt.platform.model.params.udc;

import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcValueVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.23
 **/
@Data
public class AddUdcValueParam implements Serializable {
    @ApiModelProperty("应用编码")
    @NotBlank(message = "应用编码为空")
    private String appCode;

    @ApiModelProperty("udc编码")
    @NotBlank(message = "UDC编码为空")
    private String udcCode;

    @ApiModelProperty("值编码")
    @NotBlank(message = "值编码为空")
    private String udcValueCode;

    @ApiModelProperty("值名称")
    @NotBlank(message = "值名称为空")
    private String udcValueName;

    @ApiModelProperty("值别名")
    private String valueAliasName;

    @ApiModelProperty("排序")
    private Integer udcOrder;

    @ApiModelProperty("是否启用")
    private Boolean allowStart;

    @ApiModelProperty("描述")
    private String udcValueDescribe;

    @ApiModelProperty("是否内置")
    private Boolean allowDefault;

    @ApiModelProperty("上级值编码")
    private String parentUdcValueCode;
}
