package com.elitescloud.cloudt.platform.model.params.udc;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * UDC值保存.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/13
 */
@Data
@ApiModel(description = "UDC值保存信息")
public class UdcValueSaveVO implements Serializable {
    private static final long serialVersionUID = 5949350800158311752L;

    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("应用编码")
    @NotBlank(message = "应用编码不能为空")
    private String appCode;

    @ApiModelProperty(value = "udc编码", position = 1)
    @NotBlank(message = "UDC编码不能为空")
    private String udcCode;

    @ApiModelProperty(value = "值编码", position = 2)
    @NotBlank(message = "值编码不能为空")
    private String udcValueCode;

    @ApiModelProperty(value = "值名称", position = 3)
    @NotBlank(message = "值名称不能为空")
    private String udcValueName;

    @ApiModelProperty(value = "值别名", position = 4)
    private String valueAliasName;

    @ApiModelProperty(value = "上级UDC值编码", position = 5)
    private String parentUdcValueCode;

    @ApiModelProperty(value = "排序", position = 6)
    private Integer udcOrder;

    @ApiModelProperty(value = "是否启用", position = 7)
    private Boolean allowStart;

}
