package com.elitescloud.cloudt.platform.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.convert.ApiPermissionConvert;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformApiPermissionDO;
import com.elitescloud.cloudt.platform.model.params.api.AddApiPermissionParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformApiPermissionVO;
import com.elitescloud.cloudt.platform.service.SysPlatformApiPermissionService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformApiPermissionRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Service
@Slf4j
@RequiredArgsConstructor
public class SysPlatformApiPermissionServiceImpl implements SysPlatformApiPermissionService {
    private final SysPlatformApiPermissionRepo sysPlatformApiPermissionRepo;
    private final SysPlatformMenusRepoProc menusRepoProc;

    @Override
    public ApiResult<List<SysPlatformApiPermissionVO>> getApiPermission(String menusCode) {
        var listDO = sysPlatformApiPermissionRepo.findAllByMenusCode(menusCode);

        return ApiResult.ok(listDO.stream()
                .map(ApiPermissionConvert.INSTANCE::sysPlatformDOToSysPlatformVO)
                .collect(Collectors.toList())
        );
    }

    @Override
    public ApiResult<Boolean> deleteApiPermission(Long id) {
        sysPlatformApiPermissionRepo.deleteById(id);
        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<Long> addApiPermission(AddApiPermissionParam addApiPermission) {
        var qdo = QSysPlatformApiPermissionDO.sysPlatformApiPermissionDO;
        var apiCount = sysPlatformApiPermissionRepo.count(
                qdo.permissonCode.eq(addApiPermission.getPermissonCode()));
        if (apiCount != 0) {
            return ApiResult.fail("权限编码重复");
        }
        var apiDo = ApiPermissionConvert.INSTANCE.saveParamToDo(addApiPermission);

        if (StringUtils.hasText(addApiPermission.getMenusCode())) {
            String appCode = menusRepoProc.getAppCode(addApiPermission.getMenusCode());
            apiDo.setAppCode(appCode);
        }

        return ApiResult.ok(sysPlatformApiPermissionRepo.save(apiDo).getId());
    }
}
