/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.convert.SysPlatformNumberRuleDtlConvert;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleDtlDTO;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleDtlVO;
import com.elitescloud.cloudt.platform.service.ISysPlatformNumberRuleDtlService;
import com.elitescloud.cloudt.platform.service.repo.number.SysPlatformNumberRuleDtlRepo;
import com.elitescloud.cloudt.platform.service.repo.number.SysPlatformNumberRuleDtlRepoProc;
import com.elitescloud.cloudt.platform.service.repo.number.SysPlatformNumberRuleRepoProc;
import com.elitescloud.cloudt.system.constant.SysNumType;
import com.elitescloud.cloudt.system.service.SysTenantBasicDataService;
import com.elitescloud.cloudt.system.service.config.TenantProperties;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNumberRuleDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNumberRuleDtlDO;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ISysPlatformNumberRuleDtlServiceImpl
extends BaseServiceImpl
implements ISysPlatformNumberRuleDtlService {
    private static final Logger log = LogManager.getLogger(ISysPlatformNumberRuleDtlServiceImpl.class);
    private static final SysPlatformNumberRuleDtlConvert CONVERT = SysPlatformNumberRuleDtlConvert.INSTANCE;
    @Autowired
    private SysPlatformNumberRuleDtlRepo sysNumberRuleDtlRepo;
    @Autowired
    private SysPlatformNumberRuleRepoProc numberRuleRepoProc;
    @Autowired
    private SysPlatformNumberRuleDtlRepoProc sysPlatformNumberRuleDtlRepoProc;
    @Autowired(required=false)
    private TenantProperties tenantProperties;
    @Autowired
    private SysTenantBasicDataService tenantBasicDataService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateInBatch(List<SysPlatformNumberRuleDtlVO> details) {
        if (CollectionUtils.isEmpty(details)) {
            return ApiResult.fail((String)"\u89c4\u5219\u660e\u7ec6\u4e3a\u7a7a");
        }
        Long ruleId = details.get(0).getRuleId();
        if (ruleId == null) {
            return ApiResult.fail((String)"\u53d1\u53f7\u89c4\u5219ID\u4e3a\u7a7a");
        }
        SysPlatformNumberRuleDO rule = (SysPlatformNumberRuleDO)this.numberRuleRepoProc.get(ruleId);
        if (rule == null) {
            return ApiResult.fail((String)"\u53d1\u53f7\u89c4\u5219\u4e0d\u5b58\u5728");
        }
        this.sysPlatformNumberRuleDtlRepoProc.deleteByRuleId(ruleId);
        AtomicInteger i = new AtomicInteger();
        List detailDoList = details.stream().map(detail -> {
            detail.setRuleId(ruleId);
            detail.setRuleCode(rule.getRuleCode());
            if (detail.getSeq() == null) {
                detail.setSeq(i.getAndIncrement());
            }
            if (SysNumType.NN.name().equals(detail.getNumberType())) {
                Assert.isTrue((detail.getNnLen() != null && detail.getNnLen() > 0 ? 1 : 0) != 0, (String)"\u53d6\u53f7\u7c7b\u578b\u662f[\u4e0b\u4e00\u7f16\u53f7]\u65f6\u81ea\u589e\u5e8f\u53f7\u5bbd\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            return CONVERT.voToDO((SysPlatformNumberRuleDtlVO)detail);
        }).collect(Collectors.toList());
        this.sysNumberRuleDtlRepo.saveAll(detailDoList);
        this.syncToTenant(rule.getAppCode(), rule.getRuleCode());
        return ApiResult.ok((Object)ruleId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> removeByIds(List<Long> ids) {
        Long id;
        if (CollectionUtils.isEmpty(ids)) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        Long ruleId = null;
        Iterator<Long> iterator = ids.iterator();
        while (iterator.hasNext() && (ruleId = this.sysPlatformNumberRuleDtlRepoProc.getRuleId(id = iterator.next())) == null) {
        }
        if (ruleId == null) {
            return ApiResult.fail((String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        SysPlatformNumberRuleDO rule = (SysPlatformNumberRuleDO)this.numberRuleRepoProc.get(ruleId);
        if (rule == null) {
            return ApiResult.fail((String)"\u53d1\u53f7\u89c4\u5219\u4e0d\u5b58\u5728");
        }
        this.sysPlatformNumberRuleDtlRepoProc.delete(ids);
        List<SysPlatformNumberRuleDtlDO> details = this.sysPlatformNumberRuleDtlRepoProc.queryDetails(ruleId);
        if (details.isEmpty()) {
            return ApiResult.ok((Object)true);
        }
        int seq = 0;
        for (SysPlatformNumberRuleDtlDO detail : details) {
            detail.setSeq(Integer.valueOf(seq));
            ++seq;
        }
        this.sysNumberRuleDtlRepo.saveAll(details);
        this.syncToTenant(rule.getAppCode(), rule.getRuleCode());
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> removeByRuleId(Long ruleId) {
        if (ruleId == null) {
            return ApiResult.fail((String)"\u89c4\u5219ID\u4e3a\u7a7a");
        }
        SysPlatformNumberRuleDO rule = (SysPlatformNumberRuleDO)this.numberRuleRepoProc.get(ruleId);
        if (rule == null) {
            return ApiResult.fail((String)"\u53d1\u53f7\u89c4\u5219\u4e0d\u5b58\u5728");
        }
        this.sysPlatformNumberRuleDtlRepoProc.deleteByRuleId(ruleId);
        this.syncToTenant(rule.getAppCode(), rule.getRuleCode());
        return ApiResult.ok((Object)ruleId);
    }

    @Override
    public ApiResult<List<SysPlatformNumberRuleDtlVO>> listByRuleId(Long ruleId) {
        if (ruleId == null) {
            return ApiResult.fail((String)"\u89c4\u5219ID\u4e3a\u7a7a");
        }
        List<SysPlatformNumberRuleDtlDO> details = this.sysPlatformNumberRuleDtlRepoProc.queryDetails(ruleId);
        if (details.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Map<String, String> numberTypeUdc = this.getUdcNumberTypeMap();
        List result = details.stream().map(t -> {
            SysPlatformNumberRuleDtlVO vo = CONVERT.doToVO((SysPlatformNumberRuleDtlDO)t);
            vo.setNumberTypeName((String)numberTypeUdc.get(vo.getNumberType()));
            return vo;
        }).collect(Collectors.toList());
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<List<SysPlatformNumberRuleDtlDTO>> listDtoByRuleId(Long ruleId) {
        if (ruleId == null) {
            return ApiResult.fail((String)"\u89c4\u5219ID\u4e3a\u7a7a");
        }
        List<SysPlatformNumberRuleDtlDTO> result = this.sysPlatformNumberRuleDtlRepoProc.queryByRuleId(ruleId);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<SysPlatformNumberRuleDtlVO> oneById(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        SysPlatformNumberRuleDtlVO ruleDtlVO = this.sysPlatformNumberRuleDtlRepoProc.getOptional(id).map(CONVERT::doToVO).orElse(null);
        return ApiResult.ok((Object)ruleDtlVO);
    }

    private Map<String, String> getUdcNumberTypeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("RV", "\u8fd0\u884c\u65f6\u52a8\u6001\u503c");
        map.put("FS", "\u56fa\u5b9a\u503c");
        map.put("DP", "\u683c\u5f0f\u5316\u65e5\u671f\u65f6\u95f4");
        map.put("NN", "\u4e0b\u4e00\u7f16\u53f7");
        return map;
    }

    private void syncToTenant(String appCode, String ruleCode) {
        if (this.tenantProperties == null || Boolean.FALSE.equals(this.tenantProperties.isAutoSyncBasicData())) {
            return;
        }
        this.taskExecutor.execute(() -> {
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.tenantBasicDataService.syncSequence(appCode, ruleCode);
        });
    }
}

