/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.TreeRespParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.model.entity.BaseTreeModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.constant.AreaType;
import com.elitescloud.cloudt.context.util.TreeDataUtil;
import com.elitescloud.cloudt.platform.convert.SysPlatformAreaConvert;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaDetailRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaMngTreeRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.save.PlatformAreaSaveVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAreaService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAreaRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAreaRepoProc;
import com.elitescloud.cloudt.system.service.manager.AreaManager;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAreaDO;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class SysPlatformAreaServiceImpl
extends BaseServiceImpl
implements SysPlatformAreaService {
    private static final Logger log = LogManager.getLogger(SysPlatformAreaServiceImpl.class);
    private static final SysPlatformAreaConvert CONVERT = SysPlatformAreaConvert.INSTANCE;
    @Autowired
    private SysPlatformAreaRepo areaRepo;
    @Autowired
    private SysPlatformAreaRepoProc areaRepoProc;
    @Autowired
    private AreaManager areaManager;

    @Override
    public ApiResult<List<AreaMngTreeRespVO>> tree(Boolean tree) {
        List areaList = this.areaRepoProc.getTree(null, null, null, t -> {
            AreaMngTreeRespVO respVO = new AreaMngTreeRespVO();
            respVO.setEnabled(t.getEnabled());
            respVO.setPinyin(t.getPinyin());
            respVO.setId(t.getId());
            respVO.setCode(t.getAreaCode());
            respVO.setName(t.getAreaName());
            respVO.setSortNo(t.getSortNo());
            respVO.setParentId(t.getPId());
            respVO.setParentCode(t.getParentAreaCode());
            return respVO;
        });
        if (!((Boolean)ObjectUtil.defaultIfNull((Object)tree, (Object)true)).booleanValue() || areaList.isEmpty()) {
            return ApiResult.ok((Object)areaList);
        }
        TreeDataUtil treeDataUtil = new TreeDataUtil(areaList, TreeRespParam::getId, TreeRespParam::getParentId, TreeRespParam::setChildren, Comparator.comparingInt(TreeRespParam::getSortNo));
        List result = treeDataUtil.getRoots();
        return ApiResult.ok((Object)result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(PlatformAreaSaveVO saveVO) {
        Long parentId;
        SysPlatformAreaDO areaDO = null;
        try {
            areaDO = saveVO.getId() == null ? this.checkForInsert(saveVO) : this.checkForUpdate(saveVO);
        }
        catch (IllegalArgumentException e) {
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        Long l = parentId = StringUtils.hasText((String)areaDO.getParentAreaCode()) ? this.areaRepoProc.getId(areaDO.getParentAreaCode()) : null;
        if (areaDO.getEnabled() == null) {
            areaDO.setEnabled(Boolean.valueOf(true));
        }
        if (areaDO.getSortNo() == null) {
            areaDO.setSortNo(Integer.valueOf(this.areaRepoProc.findMaxSortNo(parentId) + 1));
        }
        String oldCodePath = saveVO.getId() == null ? null : this.areaRepoProc.getCodePath(saveVO.getId());
        this.areaRepo.save(areaDO);
        this.areaRepoProc.saveTreeNode((BaseTreeModel)areaDO, parentId, areaDO.getSortNo());
        if (oldCodePath != null && !StrUtil.equals((CharSequence)oldCodePath, (CharSequence)areaDO.getCodePath())) {
            Map<Long, String> idAndCodePathMap = this.areaRepoProc.getIdAndCodePathByCodePath(oldCodePath);
            int len = oldCodePath.length();
            for (Map.Entry<Long, String> entry : idAndCodePathMap.entrySet()) {
                String newPath = areaDO.getCodePath() + entry.getValue().substring(len);
                this.areaRepoProc.updateCodePath(entry.getKey(), newPath);
            }
        }
        this.areaManager.clearCache();
        return ApiResult.ok((Object)areaDO.getId());
    }

    @Override
    public ApiResult<AreaDetailRespVO> get(Long id) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        return this.areaRepoProc.getOptional(id).map(t -> {
            AreaDetailRespVO respVO = CONVERT.do2DetailRespVO((SysPlatformAreaDO)t);
            if (StringUtils.hasText((String)t.getParentAreaCode())) {
                respVO.setParentAreaName(this.areaRepoProc.getAreaName(t.getParentAreaCode()));
            }
            if (StringUtils.hasText((String)t.getAreaType())) {
                respVO.setAreaTypeName(super.udcValue((BaseUdc)new AreaType(t.getAreaType())));
            }
            return respVO;
        }).map(ApiResult::ok).orElse(ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728"));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        SysPlatformAreaDO data = (SysPlatformAreaDO)this.areaRepoProc.get(id);
        if (data == null) {
            return ApiResult.ok((Object)id);
        }
        this.areaRepoProc.removeTreeNode((BaseTreeModel)data);
        this.areaRepoProc.delete(id);
        this.areaManager.clearCache();
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> execReBuildTree() {
        Map<String, Long> idCodeMap = this.areaRepoProc.getIdAndCode();
        if (idCodeMap.isEmpty()) {
            return ApiResult.ok();
        }
        this.areaRepoProc.rebuildTree(null, t -> StringUtils.hasText((String)t.getParentAreaCode()) ? (Long)idCodeMap.get(t.getParentAreaCode()) : null);
        this.areaManager.clearCache();
        return ApiResult.ok();
    }

    private SysPlatformAreaDO checkForInsert(PlatformAreaSaveVO saveVO) {
        SysPlatformAreaDO areaDO = CONVERT.saveVo2Do(saveVO);
        boolean exists = this.areaRepoProc.existsAreaCode(areaDO.getAreaCode(), null);
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u5730\u533a\u7f16\u7801\u5df2\u5b58\u5728");
        if (StringUtils.hasText((String)areaDO.getParentAreaCode())) {
            exists = this.areaRepoProc.existsAreaCode(areaDO.getParentAreaCode(), null);
            Assert.isTrue((boolean)exists, (String)"\u4e0a\u7ea7\u5730\u533a\u7f16\u7801\u4e0d\u5b58\u5728");
            String parentCodePath = this.areaRepoProc.getCodePath(areaDO.getParentAreaCode());
            areaDO.setCodePath(parentCodePath + "|" + areaDO.getAreaCode());
        } else {
            areaDO.setCodePath("|" + areaDO.getAreaCode());
        }
        areaDO.setPinyin(PinyinUtil.getPinyin((String)saveVO.getAreaName()));
        return areaDO;
    }

    private SysPlatformAreaDO checkForUpdate(PlatformAreaSaveVO saveVO) {
        boolean exists;
        SysPlatformAreaDO areaDO = (SysPlatformAreaDO)this.areaRepoProc.get(saveVO.getId());
        Assert.notNull((Object)areaDO, (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        if (!StrUtil.equals((CharSequence)saveVO.getAreaCode(), (CharSequence)areaDO.getAreaCode())) {
            exists = this.areaRepoProc.existsAreaCode(saveVO.getAreaCode(), null);
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u5730\u533a\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (StrUtil.isBlank((CharSequence)saveVO.getParentAreaCode())) {
            areaDO.setCodePath("|" + areaDO.getAreaCode());
        } else if (!StrUtil.equals((CharSequence)saveVO.getParentAreaCode(), (CharSequence)areaDO.getParentAreaCode())) {
            exists = this.areaRepoProc.existsAreaCode(saveVO.getParentAreaCode(), null);
            Assert.isTrue((boolean)exists, (String)"\u4e0a\u7ea7\u5730\u533a\u7f16\u7801\u4e0d\u5b58\u5728");
            String parentCodePath = this.areaRepoProc.getCodePath(areaDO.getParentAreaCode());
            areaDO.setCodePath(parentCodePath + "|" + areaDO.getAreaCode());
        }
        if (!StrUtil.equals((CharSequence)saveVO.getAreaName(), (CharSequence)areaDO.getAreaName()) || StrUtil.isBlank((CharSequence)areaDO.getAreaName())) {
            areaDO.setPinyin(PinyinUtil.getPinyin((String)saveVO.getAreaName()));
        }
        CONVERT.saveVo2Do(saveVO, areaDO);
        return areaDO;
    }
}

