/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.vo.resp.MenuBasicRespVO;
import com.elitescloud.cloudt.platform.model.vo.resp.MenuOperationRespVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessObjectDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessOperationDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysMenuOperationDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformAppDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformMenusDO;
import com.elitescloud.cloudt.system.service.model.entity.SysMenuOperationDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class MenuOperationRepoProc
extends BaseRepoProc<SysMenuOperationDO> {
    private static final QSysMenuOperationDO QDO = QSysMenuOperationDO.sysMenuOperationDO;
    private static final QSysPlatformMenusDO QDO_MENU = QSysPlatformMenusDO.sysPlatformMenusDO;
    private static final QSysPlatformAppDO QDO_APP = QSysPlatformAppDO.sysPlatformAppDO;
    private static final QSysBusinessObjectDO QDO_OBJECT = QSysBusinessObjectDO.sysBusinessObjectDO;
    private static final QSysBusinessOperationDO QDO_OPERATION = QSysBusinessOperationDO.sysBusinessOperationDO;

    public MenuOperationRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteByMenu(@NotBlank String menuCode) {
        super.delete((Predicate)MenuOperationRepoProc.QDO.menusCode.eq((Object)menuCode));
    }

    public void delete(@NotBlank String menuCode, @NotEmpty Collection<String> operationCodes) {
        super.delete((Predicate)MenuOperationRepoProc.QDO.operationCode.in(operationCodes).and((Predicate)MenuOperationRepoProc.QDO.menusCode.eq((Object)menuCode)));
    }

    public List<String> getOperationCodesByMenuCode(@NotBlank String menuCode) {
        return super.getValueListByValue((Path)MenuOperationRepoProc.QDO.operationCode, (Path)MenuOperationRepoProc.QDO.menusCode, (Object)menuCode, new OrderSpecifier[0]);
    }

    public Map<String, Long> countMenuOfOperationByBusinessObjectId(@NotEmpty Collection<Long> businessObjectIds) {
        NumberExpression countExpression = QDO.count();
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{MenuOperationRepoProc.QDO.operationCode, countExpression}).from((EntityPath)QDO)).where((Predicate)MenuOperationRepoProc.QDO.operationCode.in((SubQueryExpression)JPAExpressions.select((Expression)MenuOperationRepoProc.QDO_OPERATION.operationCode).from(new EntityPath[]{QDO_OPERATION}).where(new Predicate[]{MenuOperationRepoProc.QDO_OPERATION.businessObjectId.in(businessObjectIds)})))).groupBy((Expression)MenuOperationRepoProc.QDO.operationCode)).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)MenuOperationRepoProc.QDO.operationCode), t -> (Long)t.get((Expression)countExpression), (t1, t2) -> t1));
    }

    public List<MenuBasicRespVO> listMenusOfOperation(@NotBlank String operationCode) {
        QBean qBean = Projections.bean(MenuBasicRespVO.class, (Expression[])new Expression[]{MenuOperationRepoProc.QDO_MENU.id, MenuOperationRepoProc.QDO_MENU.menusAppCode, MenuOperationRepoProc.QDO_APP.appName.as("menusAppName"), MenuOperationRepoProc.QDO_MENU.menusName, MenuOperationRepoProc.QDO_MENU.menusType, MenuOperationRepoProc.QDO_MENU.nodeType, MenuOperationRepoProc.QDO_MENU.menusCode, MenuOperationRepoProc.QDO_MENU.menusRoute, MenuOperationRepoProc.QDO_MENU.menusDescribe});
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBean).from((EntityPath)QDO_MENU)).leftJoin((EntityPath)QDO)).on((Predicate)MenuOperationRepoProc.QDO.menusCode.eq((Expression)MenuOperationRepoProc.QDO_MENU.menusCode))).leftJoin((EntityPath)QDO_APP)).on((Predicate)MenuOperationRepoProc.QDO_APP.appCode.eq((Expression)MenuOperationRepoProc.QDO.appCode))).where((Predicate)MenuOperationRepoProc.QDO.operationCode.eq((Object)operationCode))).fetch();
    }

    public List<MenuOperationRespVO> listOperationByMenuCode(@NotBlank String menuCode) {
        return this.listMenuOperation(null, menuCode);
    }

    public Map<String, List<MenuOperationRespVO>> listOperationOfMenu(Collection<String> appCodes) {
        return this.listMenuOperation(appCodes, null).stream().collect(Collectors.groupingBy(MenuOperationRespVO::getMenusCode));
    }

    private List<MenuOperationRespVO> listMenuOperation(Collection<String> appCodes, String menuCode) {
        JPQLQuery subQueryMenuName = (JPQLQuery)JPAExpressions.select((Expression)MenuOperationRepoProc.QDO_MENU.menusName).from(new EntityPath[]{QDO_MENU}).where(new Predicate[]{MenuOperationRepoProc.QDO_MENU.menusCode.eq((Expression)MenuOperationRepoProc.QDO.menusCode)});
        Expression[] qBean = new Expression[]{MenuOperationRepoProc.QDO.id, MenuOperationRepoProc.QDO.appCode, MenuOperationRepoProc.QDO_APP.appName, MenuOperationRepoProc.QDO.menusCode, subQueryMenuName, MenuOperationRepoProc.QDO_OPERATION.businessObjectCode, MenuOperationRepoProc.QDO_OBJECT.name, MenuOperationRepoProc.QDO_OBJECT.customName, MenuOperationRepoProc.QDO.operationCode, MenuOperationRepoProc.QDO_OPERATION.customName, MenuOperationRepoProc.QDO_OPERATION.operationDescription, MenuOperationRepoProc.QDO_OPERATION.apiMethod, MenuOperationRepoProc.QDO_OPERATION.apiUrl, MenuOperationRepoProc.QDO_OPERATION.permissionRef};
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)MenuOperationRepoProc.QDO.menusCode, (Object)menuCode).andIn((SimpleExpression)MenuOperationRepoProc.QDO_OPERATION.appCode, appCodes).and((Predicate)MenuOperationRepoProc.QDO_OPERATION.id.isNotNull()).build();
        List dataList = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(qBean).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_APP)).on((Predicate)MenuOperationRepoProc.QDO_APP.appCode.eq((Expression)MenuOperationRepoProc.QDO.appCode))).leftJoin((EntityPath)QDO_OPERATION)).on((Predicate)MenuOperationRepoProc.QDO_OPERATION.operationCode.eq((Expression)MenuOperationRepoProc.QDO.operationCode))).leftJoin((EntityPath)QDO_OBJECT)).on((Predicate)MenuOperationRepoProc.QDO_OBJECT.code.eq((Expression)MenuOperationRepoProc.QDO_OPERATION.businessObjectCode))).where(predicate)).orderBy(MenuOperationRepoProc.QDO.createTime.desc())).fetch();
        if (dataList.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, String> operationNameMap = this.queryBusinessOperationNames(null);
        return dataList.stream().map(t -> {
            MenuOperationRespVO respVO = new MenuOperationRespVO();
            respVO.setId((Long)t.get((Expression)MenuOperationRepoProc.QDO.id));
            respVO.setAppCode((String)t.get((Expression)MenuOperationRepoProc.QDO.appCode));
            respVO.setAppName((String)t.get((Expression)MenuOperationRepoProc.QDO_APP.appName));
            respVO.setMenusCode((String)t.get((Expression)MenuOperationRepoProc.QDO.menusCode));
            respVO.setMenuName((String)t.get((Expression)subQueryMenuName));
            respVO.setBusinessObjectCode((String)t.get((Expression)MenuOperationRepoProc.QDO_OPERATION.businessObjectCode));
            respVO.setBusinessObjectName(CharSequenceUtil.blankToDefault((CharSequence)((CharSequence)t.get((Expression)MenuOperationRepoProc.QDO_OBJECT.customName)), (String)((String)t.get((Expression)MenuOperationRepoProc.QDO_OBJECT.name))));
            respVO.setOperationCode((String)t.get((Expression)MenuOperationRepoProc.QDO.operationCode));
            respVO.setOperationName(CharSequenceUtil.blankToDefault((CharSequence)((CharSequence)t.get((Expression)MenuOperationRepoProc.QDO_OPERATION.customName)), (String)((String)t.get((Expression)MenuOperationRepoProc.QDO_OPERATION.operationDescription))));
            respVO.setApiMethod((String)t.get((Expression)MenuOperationRepoProc.QDO_OPERATION.apiMethod));
            respVO.setApiUrl((String)t.get((Expression)MenuOperationRepoProc.QDO_OPERATION.apiUrl));
            respVO.setPermissionRef((String)t.get((Expression)MenuOperationRepoProc.QDO_OPERATION.permissionRef));
            if (StringUtils.hasText((String)respVO.getPermissionRef())) {
                respVO.setPermissionRefName((String)operationNameMap.get(respVO.getPermissionRef()));
            }
            return respVO;
        }).collect(Collectors.toList());
    }

    private Map<String, String> queryBusinessOperationNames(Predicate predicate) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{MenuOperationRepoProc.QDO_OPERATION.operationCode, MenuOperationRepoProc.QDO_OPERATION.customName, MenuOperationRepoProc.QDO_OPERATION.operationDescription}).from((EntityPath)QDO_OPERATION)).where(predicate)).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)MenuOperationRepoProc.QDO_OPERATION.operationCode), t -> CharSequenceUtil.blankToDefault((CharSequence)((CharSequence)t.get((Expression)MenuOperationRepoProc.QDO_OPERATION.customName)), (String)((String)t.get((Expression)MenuOperationRepoProc.QDO_OPERATION.operationDescription))), (t1, t2) -> t1));
    }
}

