package com.elitescloud.cloudt.platform.service;

import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.datasource.*;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/25 13:53
 */

public interface SysPlatformDatabaseSourceService {

    /**
     * 查询平台数据库源信息。
     *
     * @param queryParam 查询参数对象，包含过滤条件等。
     * @return 返回数据库源信息的列表，包含查询结果状态和数据。
     */
    ApiResult<List<SysPlatformDatabaseSourceVO>> query(SysPlatformDatabaseSourceQueryParam queryParam);


    /**
     * 查询平台数据库源密码。
     */
    ApiResult<String> queryPasswordById(Long id);

    /**
     * 根据ID获取数据库源信息。
     *
     * @param id 数据库源的ID，不能为空。
     * @return 返回特定数据库源的信息，包含查询结果状态和数据。
     */
    ApiResult<SysPlatformDatabaseSourceVO> getById(@NotNull Long id);

    /**
     * 根据数据库源代码获取信息。
     *
     * @param dbsCode 数据库源的代码，不能为空。
     * @return 返回匹配的数据库源信息，包含查询结果状态和数据。
     */
    ApiResult<SysPlatformDatabaseSourceVO> getByDbsCode(@NotNull String dbsCode);

    /**
     * 保存新的数据库源信息。
     *
     * @param saveParam 包含要保存的数据库源信息的参数对象。
     * @return 返回保存成功的数据库源ID，包含操作结果状态和数据。
     */
    ApiResult<Long> save(SysPlatformDatabaseSourceSaveParam saveParam);

    /**
     * 更新现有的数据库源信息。
     *
     * @param id 要更新的数据库源ID。
     * @param upParam 包含更新内容的参数对象。
     * @return 返回更新操作影响的行数，包含操作结果状态和数据。
     */
    ApiResult<Long> update(Long id, SysPlatformDatabaseSourceUpParam upParam);

    /**
     * 根据ID删除数据库源信息。
     *
     * @param id 要删除的数据库源ID，不能为空。
     * @return 返回删除操作影响的行数，包含操作结果状态和数据。
     */
    ApiResult<Long> delete(@NotNull Long id);

    /**
     * 测试数据库连接配置的可用性。
     *
     * @param config 包含数据库连接配置信息的对象。
     * @return 返回连接测试的结果，通常为成功或失败的消息，包含操作结果状态和数据。
     */
    ApiResult<String> testConnection(DatabaseConfigDTO config);

    ApiResult<String> testConnectionById(Long dbDataSourceId);
}
