package com.elitescloud.cloudt.platform.model.constant;

import com.elitescloud.cloudt.system.vo.SysUdcVO;

public enum PlatformApiFieldTypeEnum {
    TEXT("SYS_PLATFORM", "ApiFieldType", "字段类型", "文本", 1),
    NUMBER("SYS_PLATFORM", "ApiFieldType", "字段类型", "数字", 2),
    DATE("SYS_PLATFORM", "ApiFieldType", "字段类型", "日期", 3),
    ;

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }

    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    PlatformApiFieldTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

}
