package com.elitescloud.cloudt.platform.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Description:
 * @author: lucan.liu
 * @date: 2023.11.14
 **/
@Data
@ApiModel(value = "sys_platform_udc_value", description = "udc值")
public class SysPlatformUdcValueMngVO implements Serializable {

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("应用编码")
    private String appCode;

    @ApiModelProperty("应用名称")
    private String appName;

    @ApiModelProperty("udc编码")
    private String udcCode;

    @ApiModelProperty("udc名称")
    private String udcName;

    @ApiModelProperty("值编码")
    private String udcValueCode;

    @ApiModelProperty("值名称")
    private String udcValueName;

    @ApiModelProperty(value = "值别名", position = 4)
    private String valueAliasName;

    @ApiModelProperty("排序")
    private Integer udcOrder;

    @ApiModelProperty("是否启用")
    private Boolean allowStart;

    @ApiModelProperty("描述")
    private String udcValueDescribe;

    @ApiModelProperty("是否内置")
    private Boolean allowDefault;

    @ApiModelProperty("上级UDC值编码")
    private String parentUdcValueCode;

    @ApiModelProperty("上级UDC编码")
    private String parentUdcCode;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("租户id")
    private Long tenantId;

    @ApiModelProperty("备注")
    private String remark;




}
