package com.elitescloud.cloudt.platform.service.impl;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.convert.UdcConvert;
import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcParam;
import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcValueParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcValueMngVO;
import com.elitescloud.cloudt.platform.service.SysPlatformUdcMngService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformUdcRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformUdcValueMngRepo;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformUdcDO;
import com.elitescloud.cloudt.system.service.util.JpaPredicateBuilder;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description:
 * @author: lucan.liu
 * @date: 2023.11.13
 **/
@Service
@Slf4j
@RequiredArgsConstructor
public class SysPlatformUdcMngServiceImpl extends BaseServiceImpl implements SysPlatformUdcMngService {
    final SysPlatformUdcValueMngRepo sysPlatformUdcValueMngRepo;

    final SysPlatformUdcRepo sysPlatformUdcRepo;
    
    @Autowired
    final SysPlatformAppServiceImpl sysPlatformAppService;


    @Override
    public PagingVO<SysPlatformUdcVO> queryUdc(QueryUdcParam param) {
        //获得udc_code
        if (StringUtils.hasText(param.getUdcValueName()) || StringUtils.hasText(param.getUdcValueCode())){
            val sysPlatformUdcValueMngVO = sysPlatformUdcValueMngRepo.queryUdcCode(param);
            if (sysPlatformUdcValueMngVO != null){
                param.setUdcCode(sysPlatformUdcValueMngVO.getUdcCode());
            }
        }
        var qdo = QSysPlatformUdcDO.sysPlatformUdcDO;
        var predicate= JpaPredicateBuilder.builder()
                .and( qdo.appCode::eq,param.getAppCode())
                .and( qdo.udcName::like, StringUtils.hasText(param.getUdcName()) ? "%" + param.getUdcName()+ "%" : null)
                .and( qdo.udcCode::like, StringUtils.hasText(param.getUdcCode()) ? "%" + param.getUdcCode() + "%" : null)
                .getPredicate()
                ;
        var page = sysPlatformUdcRepo.findAll(predicate, param.getPageRequest());
        var pagingVo = PagingVO.<SysPlatformUdcVO>builder()
                .total(page.getTotalElements())
                .setRecords(page.get().map(UdcConvert.INSTANCE::selectDOToVO)
                        .collect(Collectors.toList()));
        return pagingVo;
    }

    @Override
    public List<SysPlatformUdcValueMngVO> queryUdcValue(@RequestBody HashMap<String,Object> param) {
        Assert.notNull(param.get("appCode").toString(), "应用编码不能为空！");
        Assert.notNull(param.get("udcCode").toString(), "udc编码不能为空！");
        List<SysPlatformUdcValueMngVO> udcValueMngVOList = sysPlatformUdcValueMngRepo.queryUdcValueList(param);
        if (CollectionUtils.isEmpty(udcValueMngVOList)){
            return null;
        }
        return udcValueMngVOList;
    }

    @Override
    public PagingVO<SysPlatformUdcValueMngVO> getUdcValuePage(QueryUdcValueParam param) {
        PagingVO<SysPlatformUdcValueMngVO> udcValuePage = sysPlatformUdcValueMngRepo.getUdcValuePage(param);
        if (udcValuePage.isEmpty()){
            return udcValuePage;
        }
        //应用信息
        List<CodeNameParam> codeNameParamList = sysPlatformAppService.all().getData();
        if (!CollectionUtils.isEmpty(codeNameParamList)){
            udcValuePage.getRecords().forEach(n -> {
                codeNameParamList.stream().filter(m -> m.getCode().equals(n.getAppCode()))
                        .findFirst()
                        .ifPresent(opt -> n.setAppName(opt.getName()));
            });
        }
        return udcValuePage;
    }


}
